set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4400',
      '32040200',
      '23224214',
      '20122234',
      '00202032',
      '01041230',
      '01112003',
      '00220332',
      '44134341',
      '34444021',
      NULL,
      '42023232',
      '14240222',
      '31222141',
      '20343242',
      '24314303',
      '04322010',
      '20342131',
      '11310022',
      '11200001',
      '32203442',
      '40223244',
      '03322400',
      '13224033',
      '33242130',
      '42130004',
      '20114400',
      '03331224',
      '14321412',
      '03124201',
      '32414443',
      '00434011',
      '04413003',
      '13004123',
      '32232232',
      '12021300',
      '31102034',
      NULL,
      '11131202',
      '32023123',
      '11432233',
      NULL,
      '42412331',
      '23143441',
      '03022423',
      '400',
      '03',
      NULL,
      NULL,
      '1111140',
      1,
      0.548113,
      0,
      NULL,
      '111442',
      NULL,
      NULL,
      ' 0-27-1989',
      NULL,
      NULL,
      12,
      NULL,
      4,
      9.038212,
      42,
      10,
      5,
      11.800259,
      7,
      14,
      31.960032,
      17,
      NULL,
      16.034819,
      19,
      2,
      17.826851,
      22,
      8.474425,
      20,
      38,
      9.477301,
      NULL,
      85.496116,
      NULL,
      NULL,
      139.840914,
      NULL,
      101.982216,
      ' 9-29-1979',
      60,
      17.178430,
      10,
      1,
      53,
      63.629659,
      ' 0-12-1987',
      NULL,
      NULL,
      2,
      0.731983,
      1.248378,
      NULL,
      1,
      9.116192,
      1,
      0,
      4.089412,
      1,
      1.532087,
      3,
      NULL,
      NULL,
      4.002336,
      1.245521,
      1.541008,
      9.743897,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-28-1983',
      NULL,
      14.786385,
      NULL,
      15,
      3.727025,
      NULL,
      ' 7-19-1996',
      3.944696,
      3.539680,
      11.359970,
      1.071647,
      0,
      40,
      NULL,
      NULL,
      51.203761,
      1.946790,
      0.095371,
      3,
      ' 6-19-1977',
      73.188892,
      2.199859,
      NULL,
      27,
      116.306494,
      23,
      83.619280,
      106.505964,
      94,
      56.961834,
      55,
      62,
      '11-25-1998',
      13,
      28.139373,
      28,
      73.585491,
      30,
      95,
      10.915047,
      ' 3- 8-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.180714,
      0.973662,
      ' 2-23-2003',
      186.179845,
      11,
      ' 8-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-10-1975',
      24.460220,
      ' 8-12-1994',
      5,
      8,
      ' 5- 7-1997',
      35,
      NULL,
      ' 5-19-1979',
      NULL,
      10,
      NULL,
      2.223174,
      6,
      ' 5-18-2000',
      NULL,
      3,
      0,
      NULL,
      16,
      26.056537,
      NULL,
      ' 4-19-1994',
      1,
      27.017536,
      '11-27-1976',
      6.462099,
      20.753597,
      14.685452,
      55.509103,
      NULL,
      67.838075,
      0.200429,
      1,
      ' 9- 5-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.220947);
commit;
end;
/


