set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12134131',
      '23404142',
      '24433343',
      '02410012',
      '02203210',
      NULL,
      '44144114',
      NULL,
      '31410220',
      '22434443',
      '24241002',
      '24030344',
      NULL,
      '44020240',
      '22324044',
      '04232431',
      NULL,
      '10132411',
      '40423122',
      '34011441',
      '24130032',
      NULL,
      '14210231',
      NULL,
      '13011302',
      NULL,
      '01031011',
      '30104004',
      '43142003',
      '32032320',
      NULL,
      '43331040',
      '00103343',
      '10013200',
      '12110441',
      '12442241',
      '21403032',
      '10443344',
      '34221332',
      '01224142',
      '41424311',
      '40313040',
      '43110341',
      '00341310',
      '000',
      '14',
      NULL,
      NULL,
      '4432132',
      2,
      29,
      3,
      NULL,
      '110402',
      4,
      ' 9-23-1978',
      '11-18-1994',
      24.326979,
      NULL,
      42,
      NULL,
      42.816223,
      4,
      84.451172,
      11.621668,
      11,
      NULL,
      9,
      7.479348,
      5.715397,
      10,
      32,
      3,
      30.582077,
      2.902719,
      9,
      8.903885,
      NULL,
      NULL,
      75.890515,
      16.664222,
      0,
      2.629135,
      154,
      NULL,
      NULL,
      NULL,
      188.711560,
      ' 9- 8-1976',
      37.818458,
      2.089499,
      23,
      5.197158,
      NULL,
      195,
      ' 7-12-1990',
      0,
      3,
      0.289813,
      5,
      1,
      5.584956,
      2,
      3,
      1.684829,
      0.767234,
      NULL,
      1,
      0,
      4.122936,
      1,
      1,
      3.758438,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 8-1993',
      59,
      3.038077,
      NULL,
      25.789250,
      NULL,
      0,
      ' 1-18-1982',
      NULL,
      1,
      NULL,
      0.644483,
      2,
      162,
      1.525104,
      4.079730,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-28-1994',
      29.468237,
      19.099394,
      95.137718,
      21,
      45.476705,
      NULL,
      48.228432,
      31.586234,
      80,
      10,
      71.713482,
      84.953439,
      NULL,
      0.547979,
      25.083996,
      28.082641,
      66,
      44.714773,
      130,
      1.842677,
      '10- 7-1974',
      5,
      5,
      NULL,
      NULL,
      19.688965,
      13.647815,
      NULL,
      7.371743,
      NULL,
      0,
      0.635775,
      NULL,
      25.449083,
      1.592332,
      17.446341,
      11,
      12.992914,
      9.786798,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      189.202299,
      NULL,
      ' 2-15-1978',
      NULL,
      NULL,
      NULL,
      35,
      '11-29-1992',
      NULL,
      '11-16-1987',
      10,
      1.324852,
      '11-19-2001',
      84,
      32,
      ' 7- 7-1981',
      1,
      1.100339,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      17.893850,
      '11-21-1974',
      61.609453,
      14.674361,
      37,
      ' 3-24-1980',
      NULL,
      27,
      NULL,
      8.395378,
      27.632127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


