set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3114',
      '14222444',
      '30240134',
      '34100444',
      '01034003',
      '04312414',
      '41114441',
      '00124131',
      '44210022',
      NULL,
      '20000422',
      NULL,
      '00220213',
      '12230114',
      '31034310',
      '13443441',
      '42402200',
      '10344131',
      '32002344',
      '40141411',
      '10122324',
      '12001230',
      NULL,
      '11303032',
      '21102024',
      '12431443',
      '40222431',
      '10242444',
      NULL,
      NULL,
      '12010441',
      '31200202',
      '41214012',
      NULL,
      '21341424',
      NULL,
      '42400234',
      '14214233',
      NULL,
      '02312424',
      '20033101',
      '21412213',
      '20323211',
      '42200401',
      '21101440',
      '004',
      '30',
      20,
      8.340949,
      '2303041',
      NULL,
      67,
      0,
      NULL,
      '324404',
      0,
      ' 6-12-1982',
      NULL,
      31,
      35.181302,
      NULL,
      NULL,
      30.248202,
      5.673336,
      18,
      14,
      1,
      20,
      14,
      7,
      NULL,
      6,
      34.690264,
      NULL,
      25,
      16,
      40,
      NULL,
      33,
      6,
      87,
      NULL,
      0,
      8.169293,
      NULL,
      88.829960,
      89,
      NULL,
      52.864687,
      '10-21-2000',
      NULL,
      22.645202,
      NULL,
      13,
      23.254423,
      69,
      ' 6-11-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      NULL,
      9.919649,
      2,
      NULL,
      4,
      ' 5-17-2000',
      0,
      3.141488,
      NULL,
      1,
      1.139722,
      42.327398,
      0.727234,
      0,
      4.244610,
      NULL,
      NULL,
      NULL,
      ' 3- 7-1975',
      15.272366,
      32.170249,
      45.306624,
      57.474149,
      57.455181,
      79,
      69,
      53,
      12.033374,
      71,
      83.034301,
      46,
      NULL,
      7.750330,
      NULL,
      NULL,
      86,
      16,
      136.198154,
      6,
      NULL,
      7.230940,
      4,
      NULL,
      1.145754,
      5.891865,
      5.607676,
      0,
      14,
      1.882771,
      1,
      16.634492,
      1,
      33,
      0,
      3,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      1.927838,
      ' 0- 0-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      131.043805,
      7,
      ' 1-25-1996',
      NULL,
      NULL,
      NULL,
      24.223531,
      ' 0-18-2003',
      17,
      NULL,
      3,
      5,
      ' 6-23-1977',
      146.041789,
      108,
      ' 4- 6-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      25,
      ' 2-22-1993',
      22.241683,
      NULL,
      2,
      ' 3-11-1995',
      1,
      29,
      NULL,
      9.531606,
      30,
      14,
      NULL,
      ' 4-24-1975',
      NULL,
      0,
      9.543269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


