set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '0',
      '2',
      '2',
      '4',
      '0',
      '4',
      '1',
      '3',
      '0',
      '1',
      '1',
      '0',
      '3',
      '2',
      '2',
      '4',
      '0',
      NULL,
      '3',
      '4',
      '4',
      '4',
      '',
      NULL,
      '',
      '4',
      '2',
      NULL,
      '0',
      '0',
      '',
      '',
      NULL,
      '2',
      NULL,
      NULL,
      '1',
      '2',
      '1',
      '0',
      '2',
      '2',
      '4',
      '110',
      '14344324',
      54,
      62,
      '4332313',
      1,
      10.554878,
      1,
      NULL,
      '141132',
      1,
      ' 4-23-1997',
      NULL,
      110,
      63,
      2.111137,
      3,
      NULL,
      1,
      100.864154,
      1,
      13.443744,
      7.150096,
      1,
      5,
      NULL,
      0.907557,
      18.070465,
      23,
      32,
      23,
      NULL,
      11,
      32.287444,
      15.919087,
      NULL,
      21,
      NULL,
      46,
      197,
      67,
      171,
      122,
      188,
      ' 3-20-1993',
      13.332466,
      15.299222,
      11.762594,
      8.828660,
      43,
      114,
      ' 0-13-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      4.540632,
      1,
      2.402084,
      NULL,
      1.537591,
      1.471479,
      166.479601,
      0,
      NULL,
      67,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-21-1974',
      29,
      55,
      60,
      NULL,
      NULL,
      51.046512,
      43.044299,
      52,
      59.800538,
      61,
      46,
      0,
      '11-29-1984',
      NULL,
      NULL,
      2.300345,
      NULL,
      40,
      23,
      3.527266,
      ' 9-15-1981',
      4,
      5,
      '10-20-1999',
      6,
      5,
      NULL,
      NULL,
      19,
      0,
      1.775277,
      20.566268,
      1,
      66.971749,
      0,
      0.784558,
      4,
      16.930221,
      1,
      0.073427,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-12-1999',
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 0-11-1989',
      156,
      144.697820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      ' 8-19-1987',
      38,
      30.033112,
      21,
      NULL,
      0,
      NULL,
      ' 0-12-1985',
      7,
      16.103227,
      0,
      33.075216,
      '10- 9-1995',
      11,
      NULL,
      99.004547,
      ' 0-26-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


