set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      '3',
      '4',
      '4',
      '1',
      '3',
      '2',
      '2',
      '0',
      '3',
      '3',
      '3',
      '3',
      NULL,
      '1',
      '4',
      '3',
      '0',
      NULL,
      '1',
      NULL,
      NULL,
      '',
      '2',
      NULL,
      '2',
      '1',
      '4',
      '0',
      '3',
      '',
      '',
      NULL,
      '1',
      NULL,
      '3',
      '4',
      '1',
      '1',
      '1',
      '0',
      '0',
      '0',
      '341',
      '33402422',
      73,
      NULL,
      '1220032',
      2.209262,
      205,
      NULL,
      1,
      NULL,
      3,
      ' 2- 5-1980',
      ' 3-26-1984',
      23.325321,
      NULL,
      46.236474,
      12.126955,
      11.338648,
      17,
      14.520020,
      11,
      NULL,
      4,
      NULL,
      4,
      17,
      20.217979,
      4,
      NULL,
      35,
      17.767191,
      16,
      27,
      69,
      24,
      30,
      NULL,
      1.917089,
      7,
      39,
      57.364368,
      61.866817,
      11.958577,
      33.803311,
      ' 5-20-2000',
      9,
      19.013478,
      11,
      1.354471,
      106,
      5,
      ' 8- 8-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.875824,
      14.795759,
      NULL,
      10.347364,
      10.946018,
      9.913723,
      NULL,
      0.586871,
      0.005698,
      177.855958,
      1,
      0.838377,
      4,
      0.224387,
      1.587918,
      86.791277,
      NULL,
      NULL,
      NULL,
      '10-19-2002',
      54,
      44,
      48.542330,
      79.369693,
      41,
      62,
      7.352030,
      26.626126,
      40.113152,
      5,
      63.807712,
      28.887994,
      ' 1- 0-1995',
      9,
      12.585863,
      NULL,
      11,
      31,
      135,
      8.273148,
      '10-10-1987',
      6,
      NULL,
      ' 6- 0-1987',
      NULL,
      13,
      4.249316,
      2,
      3,
      0.842873,
      0.756493,
      18,
      3,
      89,
      1,
      0,
      14.262412,
      24,
      1,
      1.220479,
      0,
      1,
      ' 4-19-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      195,
      NULL,
      ' 6-29-1999',
      NULL,
      NULL,
      NULL,
      13.290422,
      NULL,
      1.824854,
      NULL,
      NULL,
      2.343528,
      ' 3-15-1984',
      100,
      86,
      ' 8- 0-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      ' 7-24-1982',
      70,
      NULL,
      46.026086,
      '11-27-1978',
      1.550866,
      NULL,
      ' 7- 8-1981',
      17.736874,
      31,
      11.291923,
      5,
      ' 2-19-1995',
      0,
      0.150866,
      23,
      ' 8-17-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


