set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9510703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3224',
      '03421041',
      '01233301',
      '20130311',
      NULL,
      '11240043',
      '23133400',
      '32430130',
      '30040231',
      '02024023',
      NULL,
      '11011141',
      '24300421',
      '14110304',
      '04404334',
      '42043203',
      '14301132',
      '24014330',
      NULL,
      NULL,
      '30113403',
      NULL,
      '24034341',
      '32433042',
      '03332242',
      '11244214',
      '40101300',
      '12034102',
      '43420442',
      '32103142',
      '44300400',
      '43011212',
      '04202023',
      '03041324',
      NULL,
      NULL,
      NULL,
      '11424344',
      '10002441',
      '22004300',
      '40411220',
      '04231432',
      '13434011',
      '20023304',
      '43124442',
      NULL,
      '01',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      '312444',
      2.820178,
      ' 8- 3-1996',
      ' 2-21-1995',
      NULL,
      NULL,
      NULL,
      9.837007,
      NULL,
      15,
      33.070486,
      6,
      13,
      10,
      3,
      NULL,
      9.878185,
      10.846652,
      30.927118,
      14,
      16,
      9.626862,
      28,
      NULL,
      NULL,
      NULL,
      NULL,
      5.086023,
      1,
      53.278753,
      119,
      37,
      70.357824,
      NULL,
      66.645307,
      ' 6-16-1982',
      2.561830,
      9.266241,
      NULL,
      12.763863,
      134,
      145,
      ' 7-25-1995',
      3,
      1.042538,
      8,
      6.139383,
      3.227339,
      NULL,
      4,
      NULL,
      2,
      0.753436,
      1.849188,
      1.180829,
      0,
      5.384681,
      NULL,
      1.312059,
      0.532716,
      0,
      NULL,
      2.280848,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-10-1984',
      27,
      NULL,
      NULL,
      6.391919,
      23.168474,
      NULL,
      NULL,
      4.986423,
      0.780501,
      97.545528,
      0,
      NULL,
      19,
      1,
      2.642729,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-24-1976',
      NULL,
      72.312722,
      33,
      97,
      132.444198,
      35.755472,
      NULL,
      49,
      17.542393,
      6.643528,
      2.660585,
      39,
      NULL,
      4,
      3.570804,
      3,
      NULL,
      12,
      6,
      5,
      '11- 3-1987',
      1.961611,
      NULL,
      ' 5-19-1975',
      7.370796,
      NULL,
      0.615221,
      1,
      NULL,
      8,
      NULL,
      5,
      0.214765,
      28.100773,
      0.883149,
      3,
      NULL,
      26.533954,
      NULL,
      NULL,
      NULL,
      1,
      ' 2-24-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      6.434938,
      ' 2-11-1994',
      NULL,
      NULL,
      NULL,
      31,
      ' 4-24-1988',
      6.680384,
      ' 4-23-2003',
      0,
      9,
      NULL,
      33.908903,
      75.153700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 8-17-1977',
      62,
      1.013246,
      15,
      ' 2-17-1974',
      0.895367,
      241,
      ' 8-27-2000',
      NULL,
      60.393595,
      21,
      0.864204,
      '10-28-1980',
      58,
      1,
      NULL,
      ' 6-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


