set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6703486';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      '0',
      '2',
      '1',
      '4',
      '4',
      '4',
      NULL,
      '4',
      NULL,
      '4',
      NULL,
      '4',
      '2',
      '2',
      '4',
      '2',
      '3',
      '0',
      '2',
      '3',
      '4',
      '4',
      '',
      '1',
      '',
      '0',
      NULL,
      '2',
      '1',
      '3',
      '',
      NULL,
      '3',
      '3',
      NULL,
      '0',
      '3',
      '0',
      '3',
      NULL,
      '1',
      '1',
      NULL,
      '302',
      '40044330',
      69,
      8,
      NULL,
      0,
      1,
      0,
      1,
      '241434',
      NULL,
      ' 0-13-1979',
      ' 0-13-1995',
      245,
      NULL,
      31.348761,
      2,
      8,
      0.084996,
      35,
      7,
      14.826864,
      NULL,
      24.582994,
      1.020012,
      0.922206,
      5,
      19.006842,
      5.032818,
      23,
      NULL,
      NULL,
      10,
      5,
      NULL,
      20.429535,
      1.381103,
      1.853767,
      89,
      50.141578,
      48.893896,
      91.343332,
      29.838272,
      34.322110,
      ' 1- 6-1990',
      16.608960,
      3,
      3.547056,
      18,
      15,
      32,
      '10- 2-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0,
      5.375101,
      1,
      ' 9-19-2000',
      0.642288,
      NULL,
      96,
      1.467801,
      2.081119,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-25-1984',
      8,
      39,
      10.411982,
      61,
      NULL,
      37.665747,
      59.514504,
      18,
      NULL,
      43,
      NULL,
      52,
      ' 6-17-2002',
      NULL,
      3.788557,
      5,
      NULL,
      NULL,
      12,
      0,
      ' 4-13-1991',
      3.060069,
      NULL,
      NULL,
      0,
      3.189010,
      12,
      5.396323,
      2.077260,
      1.140769,
      NULL,
      13,
      1.544290,
      62,
      5,
      1.587118,
      7,
      20,
      11,
      NULL,
      NULL,
      1.739569,
      ' 0- 4-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      57.935903,
      18.790444,
      ' 5-18-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-1991',
      9,
      ' 9-26-1995',
      11.846513,
      1.819501,
      ' 8-19-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      15,
      ' 0-27-2002',
      36.098336,
      18.301292,
      NULL,
      ' 3-11-1981',
      0,
      111.117052,
      '11-22-1981',
      NULL,
      NULL,
      11.742424,
      27,
      ' 2-22-1996',
      68.200350,
      1,
      167.481486,
      '10- 8-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


