set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8706881';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '3',
      NULL,
      NULL,
      '0',
      '4',
      '3',
      '1',
      '2',
      '2',
      '1',
      '0',
      '2',
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '',
      '4',
      '1',
      '1',
      NULL,
      NULL,
      '',
      '',
      '4',
      '2',
      '0',
      '1',
      '1',
      '1',
      '3',
      '2',
      NULL,
      NULL,
      NULL,
      '110',
      '24213031',
      5,
      3,
      '2032311',
      0,
      1.121364,
      0,
      0,
      '122142',
      1,
      NULL,
      '11-15-2002',
      68.090179,
      58,
      42,
      NULL,
      NULL,
      6.534573,
      70.427746,
      0.767252,
      9.931411,
      NULL,
      28.503207,
      14.667443,
      26,
      12,
      10.122372,
      9,
      5.467780,
      4.319311,
      23,
      17,
      41,
      1.019023,
      47.430765,
      NULL,
      1,
      84.434390,
      NULL,
      67,
      153.599294,
      NULL,
      12.155215,
      ' 3- 0-1991',
      52,
      NULL,
      NULL,
      11,
      NULL,
      90,
      ' 9- 5-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.135827,
      NULL,
      167.427088,
      0,
      0.633524,
      76,
      NULL,
      NULL,
      45,
      NULL,
      NULL,
      NULL,
      ' 9- 6-1986',
      6.284373,
      14.787574,
      18.039644,
      18.291241,
      14,
      27.384645,
      0.572720,
      10,
      NULL,
      NULL,
      60,
      7.467297,
      NULL,
      3,
      1.706111,
      10,
      9.183089,
      21,
      3,
      3,
      '10-15-1989',
      8.895098,
      0,
      NULL,
      15,
      13.931956,
      6,
      7.014794,
      1,
      3,
      0,
      5,
      NULL,
      13,
      0,
      NULL,
      6,
      9.786975,
      13,
      0,
      1.859180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.704530,
      5,
      ' 5-26-2003',
      NULL,
      NULL,
      NULL,
      45,
      ' 7-13-2000',
      0.609638,
      ' 0- 1-1982',
      4,
      11.329853,
      ' 5-25-1988',
      2,
      99.677317,
      ' 4-12-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      ' 0- 5-1988',
      NULL,
      16,
      9.334847,
      '10-18-1976',
      NULL,
      33.829365,
      NULL,
      0,
      40,
      NULL,
      21,
      ' 7- 4-1988',
      18.236305,
      0.362218,
      60.118629,
      ' 6- 6-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


