set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00144331',
      '02010022',
      '01300023',
      '13343301',
      '40242141',
      '44343112',
      '41423342',
      '03000100',
      '31014110',
      NULL,
      '40412430',
      '30441014',
      '04420340',
      '24331303',
      '21044242',
      '30212133',
      '11322411',
      '44410100',
      '34141213',
      NULL,
      '20133120',
      '20122310',
      '04411411',
      '42004402',
      '23004104',
      '22241110',
      '14303214',
      '01142100',
      '44420342',
      '30401212',
      NULL,
      '14131211',
      '41100401',
      '33411340',
      '24131030',
      '30424424',
      '41402101',
      '42314212',
      '41122404',
      '21111244',
      '03102442',
      '40224030',
      '41431420',
      '22100344',
      '103',
      '23',
      NULL,
      NULL,
      '2210312',
      NULL,
      1.404797,
      3,
      NULL,
      '410102',
      NULL,
      NULL,
      ' 8-19-1995',
      95,
      NULL,
      6,
      3.250218,
      32,
      1.769273,
      21,
      5,
      0.365574,
      13,
      6,
      16.968260,
      42.723858,
      12,
      7.098084,
      3,
      NULL,
      31.397963,
      29.849182,
      NULL,
      36,
      17.507342,
      71,
      2.336002,
      1,
      121,
      43.374136,
      16.818109,
      NULL,
      137.830673,
      3.361820,
      ' 4- 1-1987',
      5,
      47,
      26,
      5.915093,
      54,
      2,
      ' 8-20-1989',
      1.809733,
      1,
      2.808609,
      0.784124,
      2.260741,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.492826,
      2.033457,
      1,
      NULL,
      5.687034,
      1.556362,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-11-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477897,
      0,
      44.557300,
      3,
      4,
      46.273734,
      0,
      1.085849,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-16-1998',
      NULL,
      27.631452,
      28.198573,
      46.569229,
      NULL,
      37.460974,
      42,
      36,
      36,
      NULL,
      75.173945,
      19,
      NULL,
      32.979306,
      21.199790,
      17.682778,
      61,
      19,
      156.258365,
      11,
      '11-15-1977',
      NULL,
      3,
      '11- 1-2001',
      10,
      10,
      4,
      10,
      24,
      16.323028,
      0,
      23,
      NULL,
      48.033499,
      1,
      7,
      19.782067,
      8,
      0.422231,
      1.343216,
      3,
      0.809380,
      ' 4- 1-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      ' 8- 4-1982',
      NULL,
      NULL,
      NULL,
      44.430227,
      ' 3-11-1997',
      NULL,
      NULL,
      6.034326,
      11,
      ' 6- 2-1977',
      49,
      NULL,
      ' 9-27-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      12,
      ' 0-12-1995',
      34.018371,
      9,
      NULL,
      ' 1-29-1982',
      3,
      1.006136,
      ' 1-14-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


