set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3104',
      '11040331',
      '23332203',
      '24302122',
      '03432203',
      '14032002',
      '13030133',
      '10334114',
      '40313133',
      NULL,
      '41331233',
      '12323433',
      '13242132',
      '32100401',
      '03042030',
      NULL,
      '14202411',
      '04333442',
      '10222343',
      '44100221',
      '12324312',
      '21241321',
      '04120120',
      NULL,
      '02033202',
      NULL,
      '44423011',
      '30431213',
      '00104010',
      '41322140',
      '20030042',
      '11303141',
      '22214141',
      NULL,
      '42134322',
      '31224221',
      '23434023',
      NULL,
      NULL,
      '33140244',
      NULL,
      '14103222',
      '04011204',
      '32033342',
      '21203430',
      '330',
      '42',
      16,
      0,
      NULL,
      NULL,
      23,
      3,
      NULL,
      '121134',
      2.177976,
      NULL,
      NULL,
      1,
      NULL,
      28.381454,
      20,
      3.525114,
      13,
      85.257640,
      19,
      6,
      11,
      36.278220,
      3,
      5,
      NULL,
      NULL,
      NULL,
      16.079085,
      NULL,
      3.642782,
      3.438422,
      20.083311,
      14.749225,
      50,
      10,
      1,
      93,
      116.695157,
      7.574602,
      NULL,
      NULL,
      103.610943,
      ' 5-19-2000',
      40,
      NULL,
      NULL,
      20,
      53.268944,
      41,
      ' 5-16-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      51,
      NULL,
      10,
      6,
      4.828012,
      ' 6-14-1994',
      1.922830,
      2.724698,
      18,
      1,
      0,
      53.672703,
      0.850790,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-11-1996',
      66.528872,
      7.345952,
      73.743620,
      67,
      47.301229,
      NULL,
      90,
      49.480379,
      NULL,
      NULL,
      63.514303,
      72.696888,
      ' 0-17-1986',
      0,
      1,
      NULL,
      7.429983,
      10.585535,
      6.768573,
      2,
      ' 6-11-1980',
      24.123631,
      16.318762,
      ' 1-25-1994',
      3,
      8.482755,
      NULL,
      7,
      21.390337,
      3,
      1.352741,
      5.268570,
      1.400253,
      10.648543,
      1,
      1,
      NULL,
      31.512961,
      NULL,
      0,
      1.550458,
      1.638364,
      ' 0- 3-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      ' 9- 9-1997',
      NULL,
      NULL,
      NULL,
      11.001048,
      ' 2-23-1996',
      NULL,
      '10-22-1990',
      NULL,
      NULL,
      ' 7-15-1978',
      81.525127,
      12,
      ' 7- 3-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      19.227847,
      ' 8-14-1988',
      NULL,
      27.132330,
      NULL,
      ' 7- 9-1991',
      1,
      9.834542,
      '10- 5-2001',
      0,
      0,
      17.101845,
      57,
      ' 4-17-1985',
      51.745816,
      0,
      9.765286,
      '11- 8-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


