set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0231',
      '22210202',
      '13434221',
      '03312210',
      '24442240',
      '13312414',
      '11204013',
      '34441341',
      '01444012',
      '43103200',
      '03214020',
      '10030304',
      '23321133',
      '30013430',
      '03332000',
      '14142341',
      '21112033',
      NULL,
      '01102222',
      '40130330',
      '34334110',
      '03403134',
      NULL,
      '34401210',
      '11401243',
      '01340003',
      NULL,
      '24324434',
      '14241332',
      '01241430',
      '10221334',
      '33413444',
      '32300040',
      '40213030',
      '11220200',
      '21133201',
      '33210303',
      '30422334',
      '40022224',
      NULL,
      '21342302',
      '12010214',
      '01130212',
      '21434114',
      NULL,
      '213',
      NULL,
      21,
      22,
      '2341442',
      3.251023,
      100.608267,
      3,
      NULL,
      NULL,
      NULL,
      ' 6- 1-2000',
      NULL,
      68.940361,
      115,
      17.222624,
      16,
      30.985764,
      20,
      52,
      17,
      5,
      NULL,
      27,
      20.108920,
      14.930177,
      17.237352,
      24,
      5,
      9.656823,
      NULL,
      21.490196,
      8.169532,
      NULL,
      14.907263,
      23.710676,
      1,
      0.312996,
      58.647966,
      NULL,
      NULL,
      127.645763,
      NULL,
      160.406890,
      ' 1- 2-1998',
      25.616261,
      13.595171,
      19.618447,
      1.968821,
      55.183638,
      NULL,
      ' 1-17-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      12,
      5.238560,
      NULL,
      NULL,
      ' 0- 7-1976',
      2.952203,
      1,
      NULL,
      NULL,
      0,
      97.798129,
      NULL,
      3,
      58.554440,
      NULL,
      NULL,
      NULL,
      ' 1- 7-1976',
      NULL,
      80,
      31.597822,
      44,
      35.340047,
      72,
      NULL,
      72,
      16,
      NULL,
      92,
      65.732711,
      ' 2- 4-1997',
      30,
      6.953522,
      22,
      NULL,
      NULL,
      114,
      0.922026,
      NULL,
      14.299645,
      NULL,
      ' 6-21-1978',
      NULL,
      11,
      NULL,
      10.366111,
      19.648786,
      NULL,
      1,
      3,
      0,
      62,
      NULL,
      1.755381,
      0,
      5,
      0,
      NULL,
      NULL,
      1.141868,
      ' 7- 7-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      15.171834,
      ' 4-11-1994',
      NULL,
      NULL,
      NULL,
      25,
      ' 9-17-1984',
      27.366003,
      ' 0-22-1980',
      10,
      1.674702,
      '10-17-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      8,
      '10-22-1997',
      66,
      NULL,
      36,
      ' 4- 4-1996',
      1.395051,
      29.180085,
      '10-13-1992',
      8,
      NULL,
      15,
      44,
      ' 0- 9-1982',
      NULL,
      0.892816,
      108,
      ' 5-11-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


