set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '4',
      '1',
      '0',
      '3',
      '2',
      '2',
      '4',
      '0',
      '1',
      '4',
      '3',
      '1',
      '2',
      '0',
      NULL,
      NULL,
      '0',
      '1',
      '1',
      '0',
      '0',
      NULL,
      '',
      '3',
      '',
      '3',
      NULL,
      '2',
      '4',
      NULL,
      '',
      '',
      '0',
      '1',
      NULL,
      '3',
      NULL,
      '1',
      '4',
      '3',
      '1',
      '3',
      NULL,
      NULL,
      '11210034',
      7.788124,
      70.512788,
      '3421301',
      1,
      217,
      2,
      1,
      '301040',
      4.056881,
      ' 6-27-1993',
      '10-18-1975',
      10,
      NULL,
      12.117630,
      13.699733,
      NULL,
      1.534394,
      69,
      15,
      1,
      14.571989,
      NULL,
      17,
      5,
      NULL,
      11.911154,
      17.456357,
      NULL,
      12,
      31.955483,
      2,
      NULL,
      NULL,
      73,
      12.476201,
      NULL,
      65.096022,
      150,
      66,
      82.455787,
      102.035800,
      190.895948,
      ' 7-15-1995',
      6,
      NULL,
      16.258406,
      NULL,
      77,
      168.771219,
      ' 3- 9-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836840,
      0.358531,
      5.387982,
      4,
      1,
      ' 5-29-1975',
      1,
      1.229162,
      169,
      1,
      1,
      20,
      0.563215,
      0,
      50,
      NULL,
      NULL,
      NULL,
      ' 9-22-1984',
      NULL,
      95,
      76,
      15.756655,
      NULL,
      35,
      NULL,
      39,
      87.747023,
      87,
      4.412617,
      75.648477,
      ' 5-15-1982',
      26.306333,
      31.590608,
      19.594459,
      88.673027,
      82.860065,
      176.987146,
      9.023459,
      ' 2- 0-1989',
      22,
      NULL,
      ' 4-27-2003',
      NULL,
      3,
      3,
      NULL,
      NULL,
      6,
      0,
      14,
      NULL,
      105,
      0,
      0.903665,
      3.518453,
      0,
      0.271272,
      NULL,
      0.045070,
      NULL,
      ' 5- 6-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      180,
      25.556967,
      ' 3-21-1995',
      NULL,
      NULL,
      NULL,
      12.673783,
      ' 1-24-1999',
      16,
      ' 1- 5-1991',
      0,
      8.195608,
      '10-27-1996',
      NULL,
      108,
      ' 7-19-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5.550139,
      '10- 6-1984',
      50,
      5.541175,
      14,
      ' 6- 9-1994',
      NULL,
      50.834413,
      ' 3-13-1979',
      NULL,
      39,
      1,
      16.906813,
      ' 9- 5-2003',
      56.583916,
      0.057645,
      61,
      ' 6-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


