set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9736648';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0212',
      '12102143',
      '44111440',
      '42240110',
      NULL,
      '22423404',
      '33414141',
      '41332112',
      '00043230',
      '00204430',
      '14224310',
      '30434243',
      '41401012',
      '01420041',
      NULL,
      '43113013',
      '04043421',
      NULL,
      '40441434',
      '44040424',
      NULL,
      '21241212',
      NULL,
      '12400041',
      '24334111',
      '33210122',
      '41423442',
      '34143242',
      '43030442',
      '11211424',
      '00224334',
      NULL,
      '12310121',
      NULL,
      '43404233',
      '42234030',
      '33343331',
      '02422440',
      '12201410',
      NULL,
      NULL,
      '20202001',
      NULL,
      '02041220',
      '22003313',
      '204',
      '31',
      38,
      2.071635,
      '0402134',
      1,
      0,
      1,
      NULL,
      '222302',
      4.513270,
      ' 9- 9-1992',
      ' 5-28-1994',
      98.519072,
      98,
      36.339099,
      16.620834,
      11.934452,
      1.186438,
      39.966521,
      4,
      5,
      NULL,
      14.932040,
      0.037119,
      NULL,
      3.589594,
      24,
      8.466992,
      5.179972,
      3.718516,
      NULL,
      NULL,
      NULL,
      5.167976,
      20.928658,
      0.814851,
      1,
      57,
      NULL,
      64.180772,
      140,
      NULL,
      11,
      '11-17-1991',
      1.801971,
      20,
      13,
      4.292304,
      137,
      160,
      ' 4-29-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      25.680541,
      6,
      36,
      NULL,
      ' 6- 8-1991',
      1.623488,
      1,
      NULL,
      0,
      4.418016,
      NULL,
      0.454791,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-25-1993',
      82,
      33,
      93.797336,
      NULL,
      115.745535,
      74,
      NULL,
      40,
      73.003945,
      83.132506,
      7,
      70.998500,
      ' 4-29-1996',
      25.928584,
      21,
      0,
      55.714493,
      85.731548,
      30,
      13,
      NULL,
      7,
      1.347771,
      NULL,
      1.010793,
      8,
      9,
      NULL,
      12,
      NULL,
      3,
      4.599112,
      1,
      40.182818,
      7.272122,
      0,
      9,
      9,
      NULL,
      6.096885,
      7,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64.760050,
      5.435567,
      ' 3- 8-1984',
      NULL,
      NULL,
      NULL,
      16,
      '10- 6-1974',
      NULL,
      ' 4-28-1979',
      8,
      3.164593,
      ' 8- 2-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      ' 1-16-1991',
      NULL,
      45,
      NULL,
      ' 9-12-1998',
      1.571690,
      56.907801,
      ' 3- 9-1993',
      1,
      160,
      7.660092,
      NULL,
      ' 9-17-1995',
      5,
      0,
      83.729865,
      '11-11-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


