set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9736648';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      '4',
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      '2',
      '0',
      '0',
      NULL,
      '4',
      '0',
      '3',
      '4',
      NULL,
      '0',
      NULL,
      '0',
      '1',
      '',
      '2',
      '',
      NULL,
      '0',
      '3',
      '0',
      '3',
      '',
      '',
      '2',
      '3',
      '2',
      NULL,
      '0',
      NULL,
      '4',
      '2',
      NULL,
      '0',
      '3',
      '034',
      NULL,
      27,
      81,
      '2010043',
      2.571283,
      20.071469,
      2,
      0,
      '314102',
      2.868337,
      ' 9-22-1984',
      NULL,
      47.433695,
      240,
      21,
      NULL,
      10,
      2.968491,
      10.494119,
      7,
      9,
      6,
      1.990052,
      NULL,
      NULL,
      NULL,
      21,
      4.652946,
      9,
      1.239143,
      56,
      3.317263,
      45.306603,
      8,
      64.432913,
      NULL,
      0,
      NULL,
      97.309782,
      24,
      60,
      93,
      32,
      ' 6-10-1988',
      NULL,
      21.388984,
      5,
      7.372187,
      82,
      NULL,
      ' 9- 5-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.806766,
      35.876917,
      1.538957,
      1.248985,
      16,
      NULL,
      '10-22-1976',
      0,
      0,
      127,
      NULL,
      0,
      NULL,
      4,
      0.003935,
      49,
      NULL,
      NULL,
      NULL,
      ' 7-14-1988',
      NULL,
      72,
      53.679669,
      49,
      NULL,
      75,
      25.287625,
      15,
      20,
      57.886556,
      27.457983,
      54,
      NULL,
      18.234060,
      NULL,
      10.949239,
      NULL,
      53.170082,
      33.407691,
      NULL,
      '10-12-1999',
      2,
      7.136196,
      NULL,
      4,
      8,
      1.550714,
      NULL,
      11.090927,
      0,
      1.550300,
      NULL,
      0.462751,
      8.328797,
      2,
      NULL,
      2,
      15.242349,
      4.537022,
      8,
      2,
      0,
      ' 0-23-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      38.239670,
      9,
      ' 6-29-1995',
      NULL,
      NULL,
      NULL,
      18,
      ' 4-23-1982',
      38,
      ' 9-24-1996',
      4.351310,
      4,
      ' 3- 2-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6,
      ' 5- 0-1978',
      41.868170,
      23,
      23.740862,
      ' 1- 0-1995',
      NULL,
      91,
      NULL,
      NULL,
      13.434982,
      16,
      48.042595,
      NULL,
      20.098889,
      0,
      70,
      ' 6- 2-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


