set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0044',
      '24301244',
      '31344112',
      '42423210',
      NULL,
      '33100212',
      '44230211',
      '42413033',
      '21104340',
      '02111011',
      '00013014',
      '40424140',
      NULL,
      '00312024',
      '24312310',
      '42323304',
      '31242430',
      '34343120',
      '31112234',
      NULL,
      '01042441',
      '24140300',
      NULL,
      '32204003',
      '43310344',
      '30301031',
      '12322211',
      NULL,
      NULL,
      '13132112',
      '30114024',
      NULL,
      '24004142',
      '33231143',
      '10143100',
      '01410401',
      NULL,
      NULL,
      NULL,
      '32021121',
      NULL,
      NULL,
      NULL,
      '31221211',
      '31022020',
      '323',
      '44',
      47,
      16,
      '4234223',
      0.492533,
      NULL,
      3,
      NULL,
      '113101',
      2,
      ' 6-15-1978',
      ' 9-27-2003',
      109.683551,
      34.084859,
      40,
      NULL,
      22,
      4.831724,
      85,
      NULL,
      22,
      NULL,
      53,
      15,
      NULL,
      7.654485,
      21,
      14.204089,
      21,
      25,
      NULL,
      14,
      53,
      10.542202,
      58.433023,
      8.103820,
      1,
      NULL,
      182.019924,
      3.737893,
      58,
      238,
      NULL,
      ' 4- 6-1974',
      58.659536,
      43,
      17,
      NULL,
      90,
      23,
      ' 8- 9-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74.405188,
      3.492184,
      5,
      5.701126,
      0.956354,
      NULL,
      ' 4- 3-1996',
      1.907169,
      1,
      NULL,
      1.404634,
      0.994920,
      46.234327,
      1.364255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-18-2000',
      49.257008,
      89.946002,
      33,
      75,
      35,
      95.895363,
      38.439142,
      NULL,
      83.991902,
      56,
      7.662712,
      NULL,
      ' 2-14-1991',
      0.924386,
      NULL,
      19.234617,
      NULL,
      NULL,
      0.454885,
      7,
      ' 2-19-1977',
      15,
      NULL,
      '10- 9-1987',
      2,
      0.517225,
      8,
      21,
      NULL,
      8.712376,
      NULL,
      2,
      0,
      65,
      1,
      0.244340,
      11,
      0,
      2,
      0,
      NULL,
      1.658543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      3,
      ' 6- 6-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-28-1979',
      NULL,
      ' 4- 8-1994',
      9.769014,
      4,
      ' 3-23-1995',
      18,
      NULL,
      ' 7- 1-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      ' 1- 3-2002',
      17.678367,
      5,
      25,
      ' 3-19-1986',
      0,
      47.431566,
      ' 9-22-1977',
      12,
      68.724778,
      9,
      56,
      NULL,
      NULL,
      NULL,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


