set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '3',
      NULL,
      '3',
      '0',
      '4',
      '4',
      '0',
      '0',
      NULL,
      '0',
      '2',
      '3',
      NULL,
      '0',
      '0',
      '0',
      '0',
      NULL,
      '0',
      '2',
      '3',
      '3',
      '',
      NULL,
      NULL,
      '2',
      '2',
      '4',
      '2',
      NULL,
      '',
      NULL,
      '4',
      NULL,
      '4',
      '2',
      '3',
      '4',
      '0',
      '4',
      '1',
      '1',
      '1',
      '410',
      NULL,
      NULL,
      1.750731,
      '2112023',
      NULL,
      39.645109,
      2,
      NULL,
      NULL,
      1,
      ' 2-12-1990',
      ' 0-17-1977',
      11.683037,
      31,
      22.048379,
      18.313249,
      NULL,
      13,
      94,
      14.916291,
      14,
      NULL,
      25,
      NULL,
      51,
      27.634624,
      21,
      17,
      2,
      15.636046,
      NULL,
      NULL,
      36,
      13,
      13,
      NULL,
      NULL,
      NULL,
      0.136266,
      39.742338,
      NULL,
      NULL,
      185,
      ' 7- 6-1979',
      NULL,
      53.977288,
      1,
      9,
      NULL,
      188,
      '10-20-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      12,
      7.719607,
      16.518263,
      10,
      7,
      ' 2-28-1998',
      1,
      0,
      101.764257,
      0.837608,
      0.307682,
      76,
      1,
      0.878706,
      57,
      NULL,
      NULL,
      NULL,
      ' 3-25-1985',
      35.056178,
      NULL,
      NULL,
      96.051859,
      96,
      108.410353,
      94,
      55,
      11.022805,
      75,
      68.780411,
      18,
      ' 1- 2-1976',
      9.455690,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      0,
      ' 8-21-2003',
      NULL,
      19,
      ' 8-13-1986',
      5,
      9.445626,
      11,
      19.820422,
      NULL,
      5,
      1.528700,
      16,
      NULL,
      16,
      1.478249,
      0.471003,
      4,
      22.265498,
      1.954588,
      NULL,
      0.214471,
      0,
      '10-19-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      156,
      NULL,
      ' 1- 4-1981',
      NULL,
      NULL,
      NULL,
      36.333284,
      ' 0- 5-1985',
      23,
      ' 5-22-1996',
      9.512821,
      3.653513,
      ' 3-26-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      18,
      ' 8- 7-1990',
      34.004632,
      4.015830,
      25.352934,
      ' 4-25-1985',
      1,
      88.466698,
      ' 5- 7-1998',
      5,
      5,
      5.080283,
      NULL,
      ' 0-18-1981',
      2.654449,
      1.214361,
      55.880824,
      ' 6- 4-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


