set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7718730';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1432',
      '24403330',
      '02242424',
      '24101242',
      '10324331',
      '42312234',
      '21121440',
      '42442333',
      '31021101',
      '21133101',
      '32432320',
      NULL,
      '04441021',
      '21141142',
      '33031202',
      '21041424',
      '32324202',
      '44230441',
      '04001130',
      NULL,
      '23243322',
      '34121022',
      '43142010',
      '43404303',
      '13044403',
      '11414423',
      '10242142',
      '40434201',
      '41002322',
      '44231430',
      '32332232',
      '24403131',
      '22344242',
      '12232322',
      '20232240',
      '30233241',
      '21001204',
      '33020241',
      '31122221',
      '04014014',
      '20341331',
      '43122340',
      NULL,
      '10441312',
      '01320211',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '102332',
      0,
      ' 8-18-2003',
      ' 1-13-1992',
      58.627023,
      NULL,
      NULL,
      NULL,
      12,
      15,
      45.027577,
      11,
      4.158924,
      5,
      12.365444,
      15.495561,
      2.667990,
      5,
      33,
      15,
      8.718744,
      NULL,
      14,
      13.820520,
      NULL,
      5,
      87.713232,
      17.782995,
      NULL,
      11,
      2,
      70,
      86.283256,
      147,
      NULL,
      ' 1- 2-1988',
      2.189826,
      8,
      19,
      1.733912,
      62,
      56,
      ' 1- 4-1993',
      4.162994,
      1.824007,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0.329883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-20-1975',
      NULL,
      81,
      34,
      108.118019,
      53.370972,
      NULL,
      126,
      72.462011,
      NULL,
      45,
      33,
      NULL,
      ' 6-27-1991',
      NULL,
      1,
      1.853631,
      8.020250,
      43.020050,
      84.389353,
      5.324681,
      NULL,
      1.375129,
      2,
      ' 6-16-1986',
      2,
      4,
      NULL,
      4.401922,
      6,
      13,
      NULL,
      2.767761,
      NULL,
      89,
      0,
      NULL,
      12.504078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.806160,
      NULL,
      10.744232,
      NULL,
      NULL,
      NULL,
      ' 4-23-1999',
      6,
      14,
      9,
      1.884660,
      NULL,
      NULL,
      1,
      33.226751,
      ' 5- 6-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.293083,
      NULL,
      NULL,
      68.121015,
      NULL,
      NULL,
      19.252201,
      31.176622,
      0.221269,
      NULL,
      NULL,
      0.496140,
      78,
      1.636535,
      0.400756,
      81,
      3,
      1,
      106.883128,
      NULL,
      NULL,
      66,
      NULL,
      25.426368,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.452528,
      0.256322,
      0.048886,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      16,
      1.248622,
      7.405364,
      0.934756,
      5,
      0.147372,
      4.103569,
      0.851339,
      NULL,
      1.042210,
      NULL,
      NULL,
      NULL,
      NULL,
      25.073594,
      6,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      4.648975,
      7.576346,
      1.465089,
      5.348003,
      0,
      1,
      NULL,
      0.599647,
      NULL,
      NULL,
      '10-15-1977',
      ' 9-22-1975',
      ' 7-11-1999',
      ' 1- 3-2000',
      ' 9- 1-2000',
      ' 2-15-1996',
      NULL);
commit;
end;
/


