set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9114751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3314',
      '04403243',
      '20231241',
      '43223342',
      '04214303',
      NULL,
      '21430344',
      '22301221',
      '10410434',
      '41123422',
      '34443442',
      '32103230',
      '20204010',
      '04212141',
      '44031201',
      '14442311',
      NULL,
      '10000232',
      '11320120',
      '33101230',
      '14242211',
      '22214432',
      '10322041',
      '00143221',
      '21034243',
      NULL,
      '40042400',
      '31232223',
      '03310340',
      NULL,
      '22031400',
      '20200243',
      '34040132',
      '34041410',
      '14041032',
      '24030100',
      '24003330',
      '24122212',
      NULL,
      NULL,
      '43441112',
      '01314210',
      '32423412',
      '10233000',
      '14423233',
      '421',
      '14',
      NULL,
      NULL,
      '1320411',
      0,
      0.181650,
      NULL,
      NULL,
      '101040',
      3.200535,
      ' 1- 5-1984',
      ' 2-12-1981',
      34.850216,
      NULL,
      37.981583,
      21.730185,
      10,
      NULL,
      20,
      11.073520,
      24,
      18,
      34,
      14.006522,
      39,
      NULL,
      8.292212,
      19,
      16.621804,
      13,
      85,
      7.545617,
      29.857200,
      1,
      99.016507,
      39,
      0,
      33.589757,
      184,
      138.659466,
      278,
      14,
      247,
      NULL,
      21,
      71.573478,
      24,
      29,
      149.263693,
      0,
      ' 0-19-1995',
      1,
      1.956697,
      5,
      0.212528,
      1,
      0.929383,
      1,
      0.150505,
      0,
      1,
      1,
      1.198840,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-21-1990',
      34.116037,
      36.460896,
      12,
      10,
      10.072829,
      5.383608,
      ' 9-29-1983',
      0,
      1.156619,
      120.844192,
      1.482500,
      0.198872,
      32,
      0,
      1,
      86,
      NULL,
      0,
      118,
      ' 0-27-1989',
      138.427199,
      134,
      74.432009,
      95,
      53,
      NULL,
      19,
      57,
      NULL,
      67.278668,
      60.465654,
      NULL,
      '10-16-1976',
      25,
      20,
      NULL,
      NULL,
      39.925693,
      79.902659,
      9,
      ' 8-23-1978',
      6,
      NULL,
      NULL,
      0.102826,
      10.247400,
      9,
      11.427809,
      22.764289,
      15.503115,
      NULL,
      18,
      1.580856,
      103.642522,
      0.917715,
      1,
      16,
      30.418348,
      0.086983,
      1,
      NULL,
      NULL,
      ' 8-14-1983',
      NULL,
      0,
      3,
      ' 7-27-2000',
      216,
      0.091016,
      ' 8- 2-1977',
      11,
      4,
      ' 5-21-1980',
      NULL,
      ' 3-16-1984',
      53,
      ' 0-27-1995',
      14.124982,
      13.332869,
      '10-11-2003',
      75.512559,
      148,
      ' 9-15-1976',
      5.748639,
      0.478915,
      ' 5- 4-1988',
      NULL,
      5,
      ' 8-29-1983',
      2,
      3,
      16,
      NULL,
      31.202577,
      10.127619,
      NULL,
      ' 2-23-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.368473);
commit;
end;
/


