set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '3',
      NULL,
      '0',
      '2',
      '4',
      '4',
      NULL,
      '4',
      '1',
      '4',
      '1',
      '1',
      '1',
      NULL,
      '3',
      '1',
      NULL,
      '4',
      '2',
      '1',
      NULL,
      '2',
      '',
      '1',
      NULL,
      '3',
      '2',
      '3',
      '0',
      '4',
      NULL,
      NULL,
      '0',
      NULL,
      '3',
      '0',
      NULL,
      '2',
      NULL,
      '0',
      '1',
      '0',
      NULL,
      '420',
      '43',
      6.560784,
      41.088714,
      '4133403',
      NULL,
      1,
      0,
      NULL,
      '302401',
      NULL,
      ' 2- 1-1995',
      ' 3- 2-1991',
      108.701321,
      55.465386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      22.185775,
      8.312120,
      22,
      NULL,
      NULL,
      ' 8- 4-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      57.573091,
      21.045673,
      NULL,
      19,
      NULL,
      ' 3- 2-1992',
      NULL,
      1,
      34.699866,
      NULL,
      0,
      28.877003,
      NULL,
      NULL,
      73.556164,
      NULL,
      NULL,
      NULL,
      ' 2- 4-1974',
      7.222744,
      53,
      NULL,
      56,
      29.079430,
      2,
      69,
      35,
      76.518598,
      28.453213,
      29.253402,
      NULL,
      ' 7-17-1980',
      NULL,
      16,
      4.084363,
      19,
      NULL,
      NULL,
      NULL,
      ' 4- 8-1986',
      3.256418,
      NULL,
      ' 0- 3-1985',
      11,
      NULL,
      12.583767,
      9,
      14,
      NULL,
      1,
      12,
      0,
      NULL,
      12.606331,
      7.051576,
      8,
      NULL,
      0.685634,
      2.594447,
      0.057425,
      0.325313,
      ' 8-14-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      137,
      36.252757,
      ' 5- 5-2002',
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      27,
      ' 0-14-1997',
      NULL,
      5,
      '10-14-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      8.896248,
      ' 5-24-1978',
      48,
      24,
      14,
      ' 8-24-1990',
      NULL,
      339,
      '10-15-2003',
      NULL,
      92,
      0,
      NULL,
      ' 0- 9-1981',
      5,
      NULL,
      67.192549,
      ' 7-19-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


