set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      '3',
      NULL,
      '1',
      '4',
      '3',
      NULL,
      '0',
      '4',
      '1',
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      '2',
      '0',
      '1',
      '0',
      '1',
      '4',
      '0',
      NULL,
      '',
      '3',
      '',
      '3',
      '3',
      '1',
      '3',
      '4',
      '',
      '',
      NULL,
      '2',
      '2',
      '0',
      '1',
      '0',
      '3',
      '2',
      '1',
      '2',
      NULL,
      NULL,
      '41042213',
      NULL,
      NULL,
      '2310334',
      0,
      30,
      3,
      NULL,
      '141233',
      0.574345,
      ' 8-14-1993',
      ' 5-18-1977',
      8.442789,
      41.059757,
      NULL,
      15,
      10.523213,
      4,
      NULL,
      7,
      NULL,
      10.819190,
      NULL,
      1,
      31,
      12,
      8.915610,
      NULL,
      3,
      NULL,
      31.541519,
      2,
      NULL,
      1,
      24.272347,
      9,
      0,
      46,
      96.113345,
      33.162662,
      46.065130,
      NULL,
      55,
      ' 1-21-1978',
      37,
      38,
      5.199733,
      NULL,
      NULL,
      130,
      '11-18-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.467604,
      40.567119,
      13,
      1.843941,
      '10-12-1988',
      0,
      0.233629,
      170,
      0,
      0,
      NULL,
      NULL,
      1.269684,
      50,
      NULL,
      NULL,
      NULL,
      ' 8-29-1984',
      32.009609,
      NULL,
      74.095683,
      32.577738,
      64.861242,
      39,
      56.683494,
      NULL,
      33,
      61,
      69,
      25,
      ' 3-25-1999',
      31,
      18,
      15,
      23.333774,
      54.326293,
      152.395811,
      9.337920,
      '11-29-1989',
      5.376833,
      1.654311,
      NULL,
      1,
      6,
      13.811193,
      NULL,
      NULL,
      2.494565,
      1,
      4,
      1,
      NULL,
      14.351462,
      1,
      13.442854,
      NULL,
      0.901460,
      5,
      0,
      1.438988,
      ' 5-25-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      53.389507,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 6-2000',
      11.879868,
      NULL,
      3,
      9.508113,
      '10-20-1998',
      137,
      51,
      ' 7-15-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      12.346548,
      NULL,
      10.014194,
      28.595702,
      23,
      ' 2- 3-1978',
      3,
      42,
      ' 3- 8-1985',
      8.746238,
      34.359464,
      NULL,
      5.073621,
      ' 2-17-1982',
      56.049196,
      0,
      66,
      '10-17-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


