set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11140032',
      '10242303',
      '31333432',
      '04041234',
      '43041322',
      '42141333',
      '40130023',
      '42322424',
      NULL,
      '03022402',
      '40340413',
      NULL,
      '24100010',
      '23320402',
      '11113223',
      NULL,
      '30440234',
      '33324200',
      NULL,
      '12122221',
      '34414411',
      '04044133',
      '30132133',
      NULL,
      NULL,
      '33344410',
      NULL,
      '02320143',
      '24042211',
      '44424122',
      '40340034',
      '01222422',
      '31240420',
      '30120010',
      '44443103',
      '23443124',
      '20121230',
      '14130211',
      NULL,
      NULL,
      '20013202',
      '22142440',
      NULL,
      '22400124',
      '',
      '',
      NULL,
      NULL,
      '3430112',
      NULL,
      0.780375,
      0,
      NULL,
      '320323',
      2.007012,
      ' 0-27-1995',
      ' 9-11-1986',
      56.080120,
      NULL,
      4,
      4.288521,
      10,
      NULL,
      NULL,
      5,
      NULL,
      8.913686,
      27,
      8,
      NULL,
      18.158215,
      25,
      NULL,
      1,
      1.604557,
      19.856409,
      14.531122,
      17.008306,
      12.829518,
      32.358986,
      NULL,
      NULL,
      4,
      94.036460,
      54,
      108.758190,
      47.211568,
      62,
      ' 4-13-1978',
      NULL,
      19.010526,
      27,
      7,
      59.504670,
      97.897679,
      '10-19-1987',
      NULL,
      7,
      2.922147,
      3.675234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.704757,
      1,
      0.837422,
      10.021794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-18-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      83.163981,
      NULL,
      66.957050,
      44,
      60.391866,
      56.184930,
      56,
      54.943194,
      NULL,
      14,
      ' 9-19-1995',
      3,
      NULL,
      NULL,
      13.251032,
      36.313920,
      NULL,
      NULL,
      ' 1-21-1974',
      4.663619,
      10,
      ' 2- 7-1996',
      NULL,
      NULL,
      NULL,
      13.370119,
      8.056352,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      13.034817,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-14-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.062655,
      1.401158,
      3.789161,
      ' 7- 2-1993',
      1,
      167.171231,
      ' 6- 3-1987',
      2,
      25,
      8.952718,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      ' 4- 7-1998',
      NULL,
      NULL,
      NULL,
      30.428853,
      22.025850,
      18.399419,
      79,
      73,
      74.826174,
      76,
      9,
      14,
      12,
      5.221061,
      33.459119,
      5,
      NULL,
      95,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      9.848665,
      4,
      365.080173,
      61.540594,
      24.522738,
      47,
      0.890536,
      59,
      0.177419,
      NULL,
      2.121810,
      1.130846,
      5.480850,
      1.919748,
      64.662642,
      NULL,
      46,
      9.075136,
      70.495480,
      22,
      1,
      8.439424,
      NULL,
      0,
      8,
      0.631503,
      1.363057,
      NULL,
      81.543470,
      NULL,
      48.798670,
      1.731510,
      0.833532,
      53.231982,
      28,
      5.907836,
      1.522021,
      33.180823,
      30.550984,
      15.925719,
      53.659411,
      3,
      16,
      0.404225,
      11,
      3,
      1.497789,
      2,
      0,
      64,
      ' 8-21-2002',
      ' 9- 3-1983',
      ' 1- 8-1979',
      ' 4-18-2000',
      ' 4-20-1989',
      NULL,
      ' 2-20-2002',
      NULL);
commit;
end;
/


