set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1013',
      '42324210',
      NULL,
      '10003300',
      NULL,
      '23030002',
      '21003111',
      NULL,
      '13313003',
      '13032340',
      '21220203',
      '42132433',
      '14222422',
      '12402001',
      '41304203',
      '03022003',
      '32320001',
      '11334043',
      '43031243',
      '24210022',
      '44032223',
      '44234300',
      '12401121',
      '44130031',
      '42334003',
      '01332040',
      NULL,
      '00022110',
      '31401034',
      '10104304',
      '00223110',
      '23041324',
      NULL,
      NULL,
      '12002123',
      '44330031',
      NULL,
      '04324031',
      NULL,
      '43142111',
      '10040300',
      '10111002',
      NULL,
      '40144113',
      '03130011',
      '002',
      '42',
      NULL,
      NULL,
      '0040000',
      2.436861,
      15.584604,
      NULL,
      NULL,
      '030313',
      0.875928,
      ' 6- 8-2000',
      ' 5- 6-1995',
      14.801381,
      NULL,
      7,
      0.167391,
      13.607277,
      14,
      6.097530,
      NULL,
      15,
      1,
      6,
      8.120589,
      18,
      25.898018,
      19.944305,
      19.784997,
      1.966778,
      10,
      26.954594,
      11.160095,
      35,
      0,
      24.927604,
      NULL,
      1.983091,
      NULL,
      115,
      8.434213,
      89.587823,
      129,
      139,
      NULL,
      27,
      7,
      10,
      NULL,
      NULL,
      57,
      ' 7-10-1990',
      0.269314,
      6,
      10,
      2,
      11.400267,
      0.728384,
      5.548581,
      2.331901,
      1,
      0.255532,
      NULL,
      1.922387,
      0,
      1,
      1,
      1,
      0.174614,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.486071,
      12,
      20,
      25.516788,
      NULL,
      ' 0-18-2000',
      1.816971,
      3,
      55.688563,
      3.586766,
      NULL,
      NULL,
      1,
      NULL,
      18.821485,
      0.797347,
      3.067687,
      111.140346,
      ' 9-25-1983',
      13.091824,
      0,
      50,
      56.120752,
      143,
      86.371512,
      83,
      77.825064,
      26.313036,
      NULL,
      82.477624,
      104.850956,
      ' 2- 9-2002',
      14.931906,
      15.575610,
      0,
      32,
      47.531214,
      37.778337,
      2,
      '10-27-1997',
      NULL,
      NULL,
      ' 6-11-1983',
      4.195642,
      12,
      25,
      11,
      NULL,
      2,
      NULL,
      16,
      0.275901,
      4.372969,
      1,
      2,
      10,
      9,
      0,
      NULL,
      NULL,
      1,
      ' 8-24-1974',
      0.390197,
      NULL,
      2,
      ' 8-26-1989',
      75,
      NULL,
      '11- 5-2003',
      NULL,
      NULL,
      NULL,
      18,
      ' 9- 9-1986',
      29,
      ' 5- 6-2003',
      4.113806,
      4,
      ' 4-11-1984',
      86,
      16,
      ' 0-22-1990',
      5.052282,
      NULL,
      ' 9- 3-1983',
      0.227573,
      3,
      ' 0-29-1986',
      NULL,
      2,
      17.024145,
      ' 7-24-1990',
      4.632998,
      1,
      4,
      ' 1-14-2000',
      0,
      13,
      ' 1-24-2003',
      0,
      10,
      16,
      29.028578,
      '11-24-1993',
      17,
      NULL,
      NULL,
      ' 6- 1-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


