set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '1',
      '0',
      '1',
      '4',
      '3',
      '2',
      '0',
      '3',
      '3',
      NULL,
      '0',
      '4',
      NULL,
      '4',
      '0',
      '1',
      '0',
      '0',
      '0',
      '3',
      NULL,
      NULL,
      '',
      '1',
      NULL,
      '0',
      '1',
      '4',
      '1',
      '3',
      '',
      NULL,
      '0',
      '1',
      '3',
      '0',
      '0',
      '0',
      '0',
      '0',
      '3',
      '4',
      '2',
      NULL,
      '30324304',
      63,
      2.526134,
      '1400211',
      NULL,
      217.701389,
      2,
      NULL,
      NULL,
      0.295058,
      ' 2- 3-1997',
      ' 2-25-1979',
      105,
      243,
      8,
      13.749853,
      8,
      2.114179,
      69,
      NULL,
      0,
      6,
      22,
      NULL,
      28,
      NULL,
      6,
      5.578854,
      3.926401,
      8.957745,
      25,
      11.115122,
      8.166985,
      1.600175,
      66,
      13,
      1,
      80.408380,
      119,
      33.754262,
      105.885201,
      43,
      75,
      ' 3- 5-2001',
      49,
      1,
      24,
      19,
      NULL,
      104.165720,
      ' 0- 6-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.163645,
      8,
      12,
      3,
      4.288569,
      ' 5-20-2000',
      0,
      NULL,
      51,
      0.163929,
      1.898333,
      50.632100,
      4.044627,
      1,
      37,
      NULL,
      NULL,
      NULL,
      ' 0-23-2002',
      8.286899,
      75,
      57,
      24.969272,
      22,
      57.601757,
      64,
      NULL,
      81.883065,
      60.557956,
      NULL,
      15.077207,
      ' 7-23-1976',
      12.939275,
      13,
      8,
      18,
      48.163119,
      14,
      4,
      '10- 9-1996',
      NULL,
      7.518695,
      '11-21-1975',
      4,
      11,
      NULL,
      12,
      5,
      3,
      0.982798,
      13,
      1,
      75,
      3,
      NULL,
      9,
      24.341342,
      NULL,
      4.422936,
      1,
      1.831640,
      ' 9-16-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      41.820800,
      53.630871,
      ' 4- 1-2000',
      NULL,
      NULL,
      NULL,
      24,
      '10- 1-1981',
      38,
      ' 0-27-1982',
      NULL,
      0,
      ' 7- 1-2000',
      3,
      66,
      ' 0-16-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 6-23-1999',
      6.889685,
      13,
      3.300435,
      ' 7-17-1993',
      NULL,
      NULL,
      '11- 1-1994',
      4.983526,
      9.095312,
      6.762207,
      59.065604,
      NULL,
      60.596870,
      NULL,
      64,
      ' 5- 6-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


