set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '3',
      NULL,
      '1',
      '0',
      '2',
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      '3',
      NULL,
      NULL,
      '4',
      '2',
      '0',
      NULL,
      '4',
      '1',
      NULL,
      '1',
      '2',
      '',
      '4',
      '',
      NULL,
      '0',
      NULL,
      '2',
      '2',
      '',
      NULL,
      '0',
      '2',
      '2',
      '0',
      '3',
      '4',
      '4',
      '4',
      '0',
      '4',
      NULL,
      '430',
      '12410024',
      74.214045,
      8,
      '0402042',
      1,
      149.404547,
      1,
      0,
      '310022',
      3,
      ' 9-15-1975',
      ' 5- 3-1994',
      NULL,
      NULL,
      18.535509,
      NULL,
      3.640596,
      9,
      8,
      15.862332,
      3,
      NULL,
      3,
      8.818750,
      40,
      8.671670,
      30.116288,
      9.431964,
      1.068603,
      7.729614,
      NULL,
      13,
      NULL,
      3,
      NULL,
      3.022020,
      1,
      60.544910,
      145.112496,
      NULL,
      43.172662,
      86,
      97.309992,
      ' 8- 8-1986',
      51,
      22.964148,
      22,
      NULL,
      104.373187,
      62,
      ' 3- 3-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52.568571,
      56,
      13,
      16.310369,
      6,
      NULL,
      NULL,
      2,
      3,
      54.155571,
      NULL,
      NULL,
      80,
      3.517309,
      NULL,
      32,
      NULL,
      NULL,
      NULL,
      '10-12-1997',
      54,
      108.229550,
      NULL,
      24,
      5,
      108.602255,
      NULL,
      68.101343,
      NULL,
      41.370047,
      48.027026,
      48.191639,
      NULL,
      NULL,
      NULL,
      3.323241,
      2,
      4,
      2.136602,
      NULL,
      ' 2-13-2003',
      14.647300,
      NULL,
      ' 9- 0-1978',
      6.873631,
      3,
      17.135082,
      NULL,
      20,
      4,
      0.791565,
      NULL,
      2.069225,
      77.130867,
      1.930246,
      1.480389,
      NULL,
      0,
      7,
      1,
      0.319861,
      1.138393,
      ' 1-24-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      107,
      13.266312,
      NULL,
      NULL,
      NULL,
      NULL,
      16.600289,
      ' 4-28-1987',
      11,
      ' 1-21-1974',
      9,
      7,
      ' 6-29-2001',
      69,
      62,
      ' 7- 7-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      8.463173,
      6,
      ' 0-21-1982',
      6,
      98,
      ' 5- 4-2000',
      8,
      100.992327,
      18.240113,
      40,
      NULL,
      7,
      1,
      6,
      ' 2-25-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


