set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3012',
      '42414021',
      '41423000',
      '11203422',
      '22220121',
      '30330322',
      '30144003',
      '10414323',
      '00144310',
      '00234142',
      '32433131',
      '03024420',
      '44200203',
      '24343210',
      NULL,
      '13331433',
      '00310324',
      '24241023',
      '43440000',
      '20043244',
      '13034224',
      '42213011',
      NULL,
      '03023314',
      '00203340',
      '11143000',
      '42130342',
      '20323204',
      '02123404',
      '00311034',
      NULL,
      '33004321',
      '30303030',
      '04041311',
      NULL,
      '24441030',
      '23231012',
      NULL,
      '21134123',
      '33004214',
      '14342002',
      '14211422',
      '00302123',
      '44121312',
      '31232022',
      '330',
      NULL,
      NULL,
      NULL,
      '0140332',
      4.969997,
      NULL,
      0,
      NULL,
      NULL,
      4,
      ' 8-11-1979',
      NULL,
      89,
      NULL,
      NULL,
      NULL,
      9.034469,
      0,
      NULL,
      NULL,
      7.218119,
      0,
      NULL,
      NULL,
      22,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      17.269249,
      9,
      NULL,
      NULL,
      NULL,
      11.066125,
      0.503552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 2-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11.588290,
      10,
      10,
      2,
      1,
      1.991483,
      2.635126,
      0.898828,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2.186730,
      0,
      0.924775,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 3-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461779,
      110.442493,
      NULL,
      5,
      47.609535,
      1,
      2.383857,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      105,
      26.634871,
      70.239620,
      22,
      NULL,
      92.789732,
      NULL,
      64.451883,
      3.689466,
      30.952562,
      14,
      19.683448,
      NULL,
      NULL,
      NULL,
      11.341950,
      48.741362,
      58,
      NULL,
      NULL,
      ' 1- 8-1986',
      NULL,
      NULL,
      NULL,
      12,
      1.254143,
      NULL,
      26,
      21,
      10.420652,
      0,
      15,
      1.221922,
      111.858893,
      NULL,
      6,
      NULL,
      28.863946,
      1,
      0.211138,
      0.822813,
      0.726294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '10-26-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      104.220927,
      ' 1-18-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


