set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9302867';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2331',
      '01201320',
      NULL,
      '41212103',
      '00312323',
      '40324403',
      '01204142',
      '43444102',
      '23204440',
      NULL,
      '14113424',
      '04204022',
      '10021324',
      '10433333',
      '03312230',
      '11030244',
      '33201000',
      '44142232',
      NULL,
      '11431344',
      '42213410',
      '40303300',
      '02030343',
      '24413234',
      '20020141',
      '41132321',
      '00041042',
      '22142203',
      '33211201',
      NULL,
      '44211143',
      '20140242',
      '00413410',
      '44220243',
      '33314412',
      '30204441',
      '04414410',
      '42001430',
      '12234114',
      '03431400',
      NULL,
      NULL,
      '23242230',
      '33022202',
      '22240034',
      NULL,
      '12',
      NULL,
      NULL,
      NULL,
      3.357450,
      0,
      0,
      NULL,
      '120000',
      2.702661,
      ' 5-27-1992',
      ' 2-29-1996',
      25,
      NULL,
      17.074240,
      3,
      31.941654,
      NULL,
      NULL,
      NULL,
      NULL,
      20.326700,
      5,
      29,
      1,
      11,
      13.104643,
      20.958296,
      9.101809,
      9.929302,
      NULL,
      19,
      69.283522,
      19.222702,
      NULL,
      33.328355,
      1,
      45,
      37.192527,
      NULL,
      NULL,
      102,
      110,
      ' 0-21-2001',
      3.396119,
      NULL,
      6.831507,
      2,
      65.530827,
      211,
      '11-14-1993',
      2,
      2,
      1.093285,
      0,
      9,
      0.037682,
      0,
      1.569790,
      1,
      0,
      NULL,
      0.292500,
      0,
      0.886500,
      0.144285,
      0.012471,
      0,
      0.172457,
      0.149356,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 9-1980',
      29.265514,
      NULL,
      2,
      4,
      1.532870,
      NULL,
      '10-23-1995',
      0.296134,
      1.350729,
      107.014598,
      0.312051,
      0,
      70.817371,
      1.014099,
      NULL,
      31,
      0.397306,
      0.417804,
      168,
      NULL,
      0,
      29.882706,
      113.508191,
      129.854468,
      10,
      NULL,
      101,
      53,
      NULL,
      NULL,
      107.052646,
      108,
      '10- 7-1979',
      9.025087,
      21.400861,
      14.983835,
      4.184824,
      47,
      145,
      8,
      ' 4-24-1996',
      0.467502,
      10.723642,
      '11- 8-1987',
      8,
      3,
      29.033730,
      15.964220,
      3.775793,
      2,
      0.109862,
      23.661273,
      1,
      NULL,
      NULL,
      0.694939,
      26.574612,
      29,
      0.686917,
      NULL,
      0.289002,
      0.883132,
      ' 7-23-1978',
      3,
      3.058256,
      3.793598,
      NULL,
      44,
      2,
      '11- 3-1978',
      2,
      4.181393,
      ' 7-23-1980',
      8.860362,
      ' 6- 7-1985',
      NULL,
      ' 3-29-1984',
      10.632551,
      0.507070,
      '10-26-1999',
      156.449455,
      118.264444,
      '11-24-1993',
      0,
      0.854106,
      ' 6-29-1986',
      1,
      4,
      ' 6-29-1975',
      1,
      3,
      3.029059,
      NULL,
      10.659893,
      5.031848,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.886213);
commit;
end;
/


