set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8821418';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3033',
      '01004211',
      '12333300',
      '41232201',
      NULL,
      '03432231',
      '42410420',
      '14234333',
      '44343101',
      '14241132',
      '21403241',
      '23430022',
      '01204143',
      '02342121',
      '41103240',
      NULL,
      '33200021',
      '20104432',
      '32140201',
      '43302213',
      NULL,
      '14432410',
      '23310031',
      '44010403',
      '43212104',
      '11444031',
      '03043103',
      '32203440',
      '31124230',
      '10043142',
      '03422403',
      '13433021',
      '03230032',
      '21434000',
      '00020302',
      '31223203',
      NULL,
      '22412031',
      '13132411',
      NULL,
      '21200200',
      '12430032',
      '41101423',
      '14240402',
      NULL,
      NULL,
      '20',
      26,
      NULL,
      '2400123',
      1.332624,
      1,
      1,
      NULL,
      '241002',
      NULL,
      '10-21-1983',
      ' 5-16-1996',
      98.934284,
      43,
      4,
      6.859264,
      17.309816,
      6.401916,
      31.004596,
      16,
      7,
      14,
      31.892604,
      11,
      29,
      5,
      NULL,
      4,
      5,
      2,
      52.033777,
      0.013645,
      NULL,
      5.112751,
      84.795556,
      17,
      1.828506,
      25,
      37,
      53,
      NULL,
      106.876618,
      NULL,
      ' 5-24-1981',
      NULL,
      47.201406,
      34.949066,
      5.802219,
      145.781846,
      110,
      ' 8- 8-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41.454788,
      21.421104,
      5.917261,
      8.178136,
      4,
      1.021750,
      ' 4-19-1979',
      0.914625,
      2,
      2.649175,
      0,
      7,
      3.651291,
      0.869565,
      0,
      35.006165,
      NULL,
      NULL,
      NULL,
      ' 1-24-1994',
      47.791732,
      109,
      23,
      59.422167,
      15.515766,
      NULL,
      68.615539,
      69,
      39.224284,
      23.263592,
      75.094719,
      NULL,
      ' 7- 6-1994',
      NULL,
      19.495290,
      19,
      61,
      NULL,
      0.780853,
      0.477346,
      ' 1-26-1996',
      3.924149,
      15,
      ' 6-13-1982',
      NULL,
      NULL,
      18,
      20.320490,
      16.273011,
      0.759638,
      NULL,
      NULL,
      0.284287,
      56,
      3.670904,
      NULL,
      6,
      13,
      3.665399,
      0,
      3,
      0,
      ' 4-13-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      156.693029,
      5,
      ' 2-18-1985',
      NULL,
      NULL,
      NULL,
      5.397886,
      NULL,
      50.150364,
      NULL,
      8,
      NULL,
      ' 3-14-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      21,
      NULL,
      17,
      1.618635,
      34.856863,
      ' 6-17-1997',
      0.430964,
      111,
      ' 6-11-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


