set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0230',
      '43130104',
      '03143033',
      '12230003',
      '04121202',
      '14242243',
      '21140431',
      '40214304',
      NULL,
      '34410132',
      NULL,
      NULL,
      '20031231',
      '10230310',
      '13122440',
      NULL,
      '22204241',
      '12332343',
      '13342120',
      '31021144',
      '11122304',
      NULL,
      '33412440',
      NULL,
      '03002322',
      '13421140',
      '21013012',
      '43013323',
      '40112323',
      '20234111',
      '31123123',
      '02130112',
      '40411434',
      '43004422',
      NULL,
      '33302214',
      NULL,
      '23031444',
      '23201010',
      '13314003',
      '33103424',
      '24242200',
      '12210010',
      '40421020',
      '34101124',
      '',
      '',
      NULL,
      NULL,
      '4411204',
      NULL,
      0.371350,
      2,
      NULL,
      NULL,
      1,
      '10-23-1982',
      '11-18-2001',
      32.961750,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448574,
      38.493036,
      3.413407,
      5,
      NULL,
      0,
      4.119276,
      3,
      NULL,
      19.442079,
      NULL,
      27.107241,
      17,
      36,
      1,
      27.119046,
      17,
      22,
      8.102845,
      NULL,
      18.215768,
      154,
      57.483526,
      128.954729,
      58.244482,
      NULL,
      ' 3-28-1982',
      32.375623,
      47,
      NULL,
      5.081205,
      NULL,
      150,
      ' 7-18-2003',
      3,
      4.366494,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751489,
      5.680865,
      0,
      1,
      0.249351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-29-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 6-2001',
      125,
      66.459890,
      25,
      122,
      22,
      2.988856,
      62.666745,
      14.806544,
      22,
      41,
      NULL,
      NULL,
      '10-28-1990',
      17.700686,
      0,
      10,
      1.255552,
      4,
      29.286019,
      0.785790,
      ' 4-26-1983',
      1.972415,
      8,
      NULL,
      1.979607,
      1.238292,
      2.596579,
      NULL,
      22,
      3,
      NULL,
      10.560752,
      NULL,
      NULL,
      1,
      1,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      20,
      13.301131,
      ' 9-15-1976',
      1.312907,
      156.367095,
      ' 1-20-1990',
      6,
      10,
      4.457476,
      NULL,
      ' 3-13-1989',
      72.466803,
      1.525516,
      369.629500,
      ' 6-25-1995',
      NULL,
      NULL,
      NULL,
      85.538945,
      32,
      1,
      1,
      10.450850,
      154,
      5.470757,
      17.584438,
      26,
      1.308401,
      11.606789,
      66,
      1.916756,
      NULL,
      35.529045,
      0.118357,
      1.962456,
      127.630132,
      1.153912,
      0,
      69.699082,
      NULL,
      NULL,
      177.068739,
      23.891271,
      18,
      43,
      1,
      NULL,
      0,
      1.807100,
      1,
      0,
      0.910552,
      0,
      61.605154,
      58,
      59,
      10,
      65.100040,
      48,
      0.641947,
      0,
      29.707716,
      NULL,
      NULL,
      1.280842,
      7,
      NULL,
      43,
      0.828806,
      NULL,
      NULL,
      0.634129,
      29,
      27,
      NULL,
      NULL,
      80,
      35.885507,
      11.124900,
      62.038429,
      7.280265,
      3,
      0.624728,
      1.506734,
      3,
      0,
      1,
      2.947658,
      10.912216,
      NULL,
      ' 1- 6-2001',
      ' 9-27-2001',
      '11-27-1985',
      ' 4-15-1996',
      '11- 1-1989',
      ' 9- 1-1987',
      NULL);
commit;
end;
/


