set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8735438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3132',
      NULL,
      '43101311',
      NULL,
      '03411001',
      '12344011',
      '04314232',
      '22214124',
      '03332422',
      '22203103',
      '31413422',
      '04022131',
      '14232240',
      '04411342',
      '24041244',
      '31242213',
      '20441341',
      '44241430',
      NULL,
      '31433143',
      '40013300',
      '30041402',
      '24021120',
      NULL,
      '23343341',
      '34321401',
      NULL,
      '12411212',
      '43111332',
      '40341110',
      '44112221',
      '31202222',
      '13313014',
      '42402410',
      '30012324',
      '42120143',
      '43310323',
      '01412044',
      '13110440',
      NULL,
      '12123432',
      '32142340',
      '01011430',
      NULL,
      '00044144',
      '311',
      '02',
      NULL,
      NULL,
      NULL,
      4,
      61.768300,
      2,
      NULL,
      NULL,
      NULL,
      ' 3-24-1999',
      ' 9- 1-1985',
      18.499043,
      NULL,
      40,
      15.189765,
      14,
      4.469723,
      42.113553,
      8,
      15,
      2.621425,
      20,
      7,
      8,
      NULL,
      26,
      18,
      3,
      NULL,
      21.361344,
      11,
      32.884715,
      8,
      57,
      NULL,
      0,
      31,
      21.749224,
      23,
      NULL,
      110,
      137.109688,
      ' 8-29-1989',
      9,
      NULL,
      12,
      NULL,
      42.389945,
      NULL,
      ' 2- 5-1997',
      1.474414,
      5.974884,
      1,
      0.629574,
      7.833886,
      0,
      9,
      4.833229,
      0,
      1.054416,
      NULL,
      0,
      0.748579,
      3.661512,
      0.826871,
      0,
      0,
      1,
      1.605578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-24-1990',
      50.496750,
      16.027368,
      23,
      6,
      NULL,
      7,
      ' 3- 8-2003',
      NULL,
      1.553466,
      81,
      0,
      NULL,
      64,
      NULL,
      1,
      63,
      NULL,
      NULL,
      NULL,
      ' 2- 4-1996',
      71,
      42.722574,
      68,
      88,
      125,
      38.135928,
      62.059930,
      103,
      92,
      77.184674,
      33,
      99,
      ' 2-11-1976',
      12,
      16,
      NULL,
      NULL,
      NULL,
      24,
      4.842875,
      '10- 2-1991',
      21.349525,
      0.326451,
      ' 4-16-1993',
      1.057307,
      2.195272,
      NULL,
      7,
      14.444694,
      3.827963,
      1,
      7.801457,
      1.930409,
      10,
      0.917268,
      1.279800,
      1.015893,
      14,
      15,
      7.094444,
      0,
      1,
      ' 9- 1-1998',
      NULL,
      NULL,
      2,
      ' 3-29-1976',
      85.095768,
      0.372371,
      ' 6-15-1994',
      NULL,
      NULL,
      NULL,
      4.463494,
      ' 7- 5-1989',
      22.983963,
      '11- 1-1989',
      12,
      8,
      ' 0-20-1978',
      40,
      80,
      ' 9-14-1997',
      0.603349,
      0.882706,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      6.971968,
      ' 4-22-1983',
      NULL,
      36.352129,
      35.422994,
      ' 5- 5-1978',
      NULL,
      29,
      ' 7-25-1991',
      4.283589,
      3,
      13.610625,
      31,
      NULL,
      NULL,
      1,
      151.683854,
      '11- 2-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3);
commit;
end;
/


