set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7827129';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '3',
      '4',
      NULL,
      '4',
      '2',
      '0',
      '0',
      '1',
      '0',
      '2',
      '2',
      '2',
      '0',
      NULL,
      '2',
      '2',
      '2',
      '2',
      NULL,
      '2',
      '3',
      '3',
      '',
      '0',
      '',
      '2',
      '1',
      '4',
      '4',
      NULL,
      '',
      '',
      '4',
      NULL,
      '1',
      '4',
      '0',
      '2',
      '4',
      '2',
      '4',
      '4',
      '4',
      NULL,
      NULL,
      0,
      41,
      '0233133',
      2,
      1,
      2,
      NULL,
      '120343',
      2.084347,
      NULL,
      ' 3- 5-2000',
      NULL,
      244.843850,
      46.538694,
      9.592925,
      11.636567,
      NULL,
      38,
      19.728919,
      1,
      6,
      33,
      15.133960,
      29,
      NULL,
      15,
      11.646567,
      27.622319,
      19,
      7,
      NULL,
      NULL,
      6.400562,
      108,
      NULL,
      0.596649,
      69.147595,
      120,
      59.320148,
      102.416622,
      89,
      149,
      '10- 1-2001',
      59,
      21,
      18.287059,
      11.820350,
      NULL,
      205.994073,
      ' 4-17-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      15,
      8,
      NULL,
      28,
      0.336536,
      ' 8-13-1996',
      1,
      0,
      146.959323,
      1,
      3,
      11,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1981',
      NULL,
      119,
      91.591966,
      72,
      47,
      95.610290,
      26.463413,
      5,
      51.890461,
      39,
      60.850682,
      106.923902,
      NULL,
      14,
      4.828612,
      15,
      NULL,
      5.746692,
      49,
      2.013308,
      ' 4-25-2002',
      1,
      15,
      ' 5-10-1989',
      NULL,
      2,
      NULL,
      4.046356,
      NULL,
      NULL,
      1,
      5.714507,
      0.118993,
      4.293755,
      1,
      1,
      10.783717,
      15.333186,
      7.564887,
      7,
      NULL,
      1.003899,
      ' 9- 9-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-29-1991',
      NULL,
      NULL,
      NULL,
      34.543170,
      ' 1- 1-1997',
      15,
      ' 1-28-2003',
      NULL,
      10,
      ' 6-17-2002',
      NULL,
      23,
      ' 4-17-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      28.139707,
      NULL,
      9,
      NULL,
      7.514531,
      ' 1-17-1984',
      1.845816,
      21.995561,
      ' 6- 6-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


