set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7827129';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      '1',
      '2',
      '2',
      '3',
      '2',
      '4',
      '1',
      '4',
      '1',
      '1',
      '1',
      '2',
      '1',
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      '4',
      '',
      '0',
      '',
      '3',
      '2',
      '1',
      '4',
      NULL,
      '',
      NULL,
      '1',
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      '0',
      NULL,
      '3',
      '124',
      NULL,
      78.219447,
      25.070977,
      '0121334',
      NULL,
      42,
      1,
      0,
      '112144',
      NULL,
      '11-24-1994',
      ' 7-16-1984',
      NULL,
      38,
      NULL,
      NULL,
      NULL,
      0.229723,
      49,
      16.320806,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.769229,
      24,
      NULL,
      NULL,
      130,
      22.259485,
      0,
      78.107048,
      0,
      65,
      140,
      NULL,
      170.884968,
      ' 5-11-2001',
      53,
      60,
      16.412329,
      31.909588,
      NULL,
      243.981445,
      ' 1- 3-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.980032,
      11.483773,
      4.906546,
      4,
      2.474810,
      '11-16-2002',
      NULL,
      0,
      212.013121,
      3.886515,
      NULL,
      120.856253,
      1.927729,
      1,
      76,
      NULL,
      NULL,
      NULL,
      NULL,
      106.143799,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      38,
      17,
      7,
      NULL,
      NULL,
      ' 2- 4-1991',
      17,
      27,
      10,
      6,
      16.193511,
      NULL,
      10.190945,
      '10- 7-1986',
      2,
      11,
      ' 3-16-1996',
      12.890073,
      2.541697,
      0.283901,
      NULL,
      2.130135,
      NULL,
      NULL,
      5,
      0.223344,
      85,
      1,
      NULL,
      20.288288,
      20.071854,
      1.199928,
      NULL,
      3.268945,
      1.293793,
      ' 4-18-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      ' 5-18-1993',
      35,
      ' 4-18-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      20.184814,
      ' 7- 6-1995',
      NULL,
      34.421659,
      31.916480,
      NULL,
      1.829563,
      4,
      ' 8- 0-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


