set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11314102',
      '11243141',
      '30311322',
      NULL,
      '22011114',
      '43043120',
      '30213223',
      '12431203',
      '33141430',
      '24123312',
      '43123242',
      NULL,
      '04321144',
      '01244243',
      '44304043',
      '24301044',
      '00224411',
      '12014024',
      '30101134',
      NULL,
      '00210034',
      '44440414',
      '44232224',
      '43432244',
      '32004411',
      '04103031',
      '03200244',
      '01201113',
      '21111142',
      '31110114',
      '44222440',
      '13330123',
      NULL,
      '11034230',
      '01322343',
      '04142411',
      '00442144',
      NULL,
      '03241340',
      '10203003',
      '10102043',
      NULL,
      NULL,
      NULL,
      '010',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.632420,
      1,
      NULL,
      '441321',
      0.722681,
      ' 0-10-1982',
      '10-15-2001',
      60.617404,
      NULL,
      17,
      8,
      29.352665,
      21,
      97.568405,
      8,
      4.158052,
      10.328382,
      43.719914,
      7,
      18.575722,
      6.448378,
      36,
      12.329609,
      23.828681,
      NULL,
      4.743955,
      13,
      45,
      1.127154,
      59.925585,
      15.560213,
      NULL,
      121.855413,
      NULL,
      NULL,
      45,
      192,
      132.383421,
      ' 6-11-2001',
      NULL,
      34,
      27,
      NULL,
      146.903554,
      62,
      NULL,
      1.445173,
      1.417715,
      1,
      0,
      1.190278,
      1,
      NULL,
      1.578590,
      1.680979,
      0,
      NULL,
      1,
      1,
      NULL,
      0.056761,
      0,
      0.483740,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 3-1976',
      101,
      16,
      0,
      1.584799,
      9.280010,
      7,
      ' 4-22-1982',
      1.400738,
      NULL,
      205.007390,
      0.341740,
      1,
      122,
      NULL,
      1.753035,
      85.359759,
      NULL,
      NULL,
      NULL,
      ' 0-25-1999',
      76,
      NULL,
      NULL,
      111.383974,
      40,
      86.927002,
      57.679301,
      109,
      NULL,
      54,
      56,
      90.381849,
      ' 8-16-1984',
      NULL,
      5.537201,
      6,
      NULL,
      NULL,
      23,
      7.256000,
      NULL,
      30,
      20,
      ' 8-10-2000',
      NULL,
      2.388546,
      23.449801,
      NULL,
      NULL,
      2.808434,
      1,
      9.903984,
      1.720198,
      49.365186,
      0.886197,
      0,
      1,
      NULL,
      1.537739,
      NULL,
      0,
      1.140545,
      '10- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      172,
      NULL,
      ' 1-17-1986',
      NULL,
      NULL,
      NULL,
      43.017256,
      NULL,
      23.536054,
      ' 5-22-2002',
      16.336998,
      NULL,
      ' 5-27-1975',
      32,
      9,
      NULL,
      5.251868,
      1,
      ' 2-25-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.357852,
      NULL,
      38.089144,
      NULL,
      NULL,
      ' 8-13-1991',
      NULL,
      39.377150,
      ' 7-18-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


