set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2134',
      '21011334',
      '42431110',
      '33432024',
      '14041041',
      '02121433',
      '14101433',
      '41102412',
      '12443420',
      NULL,
      '34220343',
      '24421140',
      NULL,
      '01310110',
      NULL,
      '33233021',
      '31341003',
      '11041121',
      '04304142',
      '12204143',
      '21130131',
      '42104421',
      '44202041',
      NULL,
      '10110444',
      NULL,
      NULL,
      '34242332',
      NULL,
      '34430212',
      NULL,
      '20444332',
      '33434304',
      NULL,
      '04102042',
      '00211301',
      '33032030',
      '40301422',
      NULL,
      '21002440',
      '00433244',
      NULL,
      NULL,
      '11202034',
      '03442023',
      '430',
      '42',
      30.394269,
      NULL,
      '3300214',
      NULL,
      25.876594,
      1,
      NULL,
      '210220',
      3,
      NULL,
      ' 9- 5-2002',
      NULL,
      NULL,
      NULL,
      6.275750,
      3.441228,
      14,
      55,
      8.100611,
      6.503628,
      16.559301,
      9.849195,
      14,
      NULL,
      11.961933,
      11.513909,
      24.152975,
      24,
      2,
      22,
      NULL,
      25.773376,
      19.846716,
      41.367752,
      28.268545,
      1,
      NULL,
      74,
      NULL,
      227,
      NULL,
      57.142107,
      ' 1- 7-1980',
      68.948476,
      38.314254,
      22.429273,
      26,
      26.781624,
      33,
      ' 0-24-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.515023,
      6.025519,
      4.506993,
      8,
      7,
      4.508133,
      NULL,
      NULL,
      2,
      175,
      0.007808,
      1.040363,
      56.471260,
      2.375510,
      1,
      120.670400,
      NULL,
      NULL,
      NULL,
      '10-20-1976',
      5,
      NULL,
      106,
      97.570647,
      1.416222,
      NULL,
      NULL,
      82.753693,
      98.734196,
      NULL,
      96,
      31,
      ' 7-27-1991',
      0,
      NULL,
      NULL,
      62.125754,
      19,
      40,
      4.526288,
      NULL,
      26.566704,
      34,
      ' 8-23-2002',
      8,
      5,
      21,
      26.517094,
      0.392498,
      NULL,
      1,
      13.850555,
      1,
      55.012058,
      0,
      1,
      16,
      NULL,
      1.659210,
      2,
      1.237049,
      NULL,
      ' 3-24-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      ' 8-14-1992',
      1,
      ' 0-22-1990',
      8,
      NULL,
      ' 9-17-1990',
      NULL,
      NULL,
      NULL,
      6.026247,
      7,
      ' 0- 9-1982',
      NULL,
      NULL,
      NULL,
      0,
      0,
      23,
      ' 7- 1-1978',
      52,
      62,
      1,
      ' 9-16-1996',
      1.571768,
      65.526519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


