set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8918903';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43243244',
      '31140340',
      '04043121',
      '41241221',
      '40220110',
      '22110122',
      '21331024',
      '00444421',
      '40303412',
      '31200210',
      '14302210',
      '31320424',
      '43132104',
      '23101414',
      NULL,
      '40014131',
      '43240112',
      NULL,
      '32440422',
      '30331110',
      '32010034',
      '14144102',
      '20313031',
      '43141141',
      '41003212',
      '11001440',
      '00242031',
      '40133243',
      '12421422',
      '13232044',
      '24231010',
      '00104003',
      '22403200',
      '21004140',
      '43240424',
      '10021012',
      '02013031',
      NULL,
      NULL,
      '30013310',
      '44100222',
      '02021040',
      NULL,
      '04021334',
      '414',
      '03',
      NULL,
      NULL,
      '2420344',
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.139850,
      ' 2-10-1982',
      NULL,
      67,
      NULL,
      NULL,
      11.960031,
      30,
      16.422876,
      16.682956,
      16.610744,
      18.660068,
      21,
      NULL,
      1,
      NULL,
      8.922160,
      25,
      NULL,
      9.738183,
      5,
      56,
      7,
      8.936708,
      3.140962,
      100.505080,
      19,
      NULL,
      80,
      114,
      91,
      80,
      37,
      NULL,
      ' 8- 8-1984',
      17,
      43.423293,
      8.144781,
      33.501246,
      NULL,
      115.800242,
      ' 9-19-1987',
      0,
      2,
      0,
      2,
      NULL,
      2.678893,
      3.221119,
      11,
      0.736290,
      1,
      3,
      1.342047,
      NULL,
      0,
      NULL,
      NULL,
      3.640943,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 4-1991',
      45,
      NULL,
      17.670118,
      0,
      14,
      7,
      ' 4- 6-1992',
      0,
      0.769181,
      172.991690,
      0,
      4,
      119,
      NULL,
      NULL,
      18.720129,
      NULL,
      NULL,
      NULL,
      ' 7-13-2003',
      33,
      NULL,
      49,
      5,
      90.456679,
      6.740372,
      19,
      63.480041,
      32.509186,
      51.666600,
      81.010759,
      59.488582,
      '10-12-1979',
      26,
      10.226088,
      13.009165,
      16,
      51,
      29.289362,
      NULL,
      '11-29-1996',
      NULL,
      NULL,
      ' 4-21-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      ' 0-11-1994',
      43.120919,
      7,
      '11- 9-1987',
      39.684932,
      NULL,
      ' 0-28-1993',
      NULL,
      '10-21-1990',
      22,
      ' 1-20-1992',
      NULL,
      2,
      ' 1- 1-1999',
      16.562894,
      88,
      '10-15-1986',
      NULL,
      7.850511,
      ' 0- 4-1996',
      NULL,
      NULL,
      NULL,
      0,
      2,
      17.645495,
      ' 2-17-1975',
      12.477689,
      31,
      13,
      NULL,
      2.361245,
      51,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.180518);
commit;
end;
/


