set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8918903';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '1',
      '4',
      '4',
      '3',
      '4',
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      '3',
      '4',
      '0',
      '0',
      NULL,
      '0',
      '4',
      '0',
      '2',
      '4',
      '2',
      '1',
      '',
      '1',
      NULL,
      '2',
      NULL,
      '2',
      '0',
      '4',
      '',
      NULL,
      NULL,
      '3',
      NULL,
      '0',
      '2',
      '0',
      '2',
      '4',
      '2',
      NULL,
      '4',
      '134',
      '20203434',
      37,
      NULL,
      '2422240',
      1,
      15.161395,
      2,
      0,
      NULL,
      0,
      ' 8-20-1978',
      ' 6- 4-1978',
      72.389232,
      49,
      NULL,
      NULL,
      9,
      NULL,
      21.313057,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.345919,
      NULL,
      NULL,
      NULL,
      126,
      5,
      3.049612,
      79,
      77,
      48,
      131,
      NULL,
      156,
      ' 4-18-1977',
      34.258160,
      17.374611,
      13.909679,
      7,
      75,
      169,
      ' 0-15-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595527,
      5,
      NULL,
      NULL,
      NULL,
      2.897244,
      ' 3-24-1984',
      NULL,
      1.675256,
      NULL,
      0.999573,
      1.843021,
      2,
      0.268510,
      0.377597,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-1986',
      1.459622,
      NULL,
      NULL,
      NULL,
      NULL,
      86.436836,
      NULL,
      NULL,
      71.196264,
      64.348921,
      60.483487,
      77.168356,
      ' 4- 2-1996',
      0.445493,
      11,
      36,
      NULL,
      72,
      NULL,
      10,
      ' 2-26-1980',
      11,
      32,
      ' 5-26-1984',
      2.458350,
      18.243649,
      24.008341,
      10,
      18.605475,
      5,
      0,
      12.623116,
      1.351570,
      65,
      0,
      0.649651,
      16,
      12.165360,
      0.196199,
      0.820780,
      1,
      NULL,
      ' 3- 1-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      ' 8-12-1995',
      12.977211,
      ' 8- 7-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      9,
      NULL,
      34,
      34,
      62.060655,
      NULL,
      3.458027,
      31,
      ' 9- 6-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


