set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7323049';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1332',
      '01340121',
      '23120330',
      '00011034',
      '01142002',
      '03042304',
      '10203434',
      NULL,
      '12434141',
      NULL,
      NULL,
      '04020024',
      '40400340',
      '33103123',
      '33001000',
      NULL,
      '11303434',
      '30340334',
      '14434120',
      NULL,
      '42004142',
      '21114101',
      '03303040',
      '24044120',
      '24222411',
      '12121200',
      '04103221',
      '01131200',
      '31444033',
      '12413413',
      '44313201',
      '20141202',
      NULL,
      '43334212',
      '40132222',
      '31204043',
      '13043030',
      '40341124',
      '04140233',
      '10412103',
      '03403300',
      NULL,
      '00142421',
      '00213241',
      '01012202',
      NULL,
      '03',
      NULL,
      NULL,
      NULL,
      0.250630,
      1,
      1,
      NULL,
      '040001',
      2,
      NULL,
      NULL,
      114,
      NULL,
      7,
      24,
      NULL,
      17.800467,
      5.350659,
      NULL,
      15,
      12.414668,
      19.892172,
      15.429013,
      NULL,
      11,
      27,
      NULL,
      0.039001,
      NULL,
      24,
      NULL,
      21.334942,
      NULL,
      72,
      NULL,
      1.548459,
      39.580204,
      64.952641,
      24,
      NULL,
      NULL,
      85,
      NULL,
      30,
      33,
      31,
      1,
      22,
      158.592710,
      ' 6-24-1975',
      1.173679,
      1.729794,
      1.852870,
      0.956828,
      5.581357,
      1.038917,
      0,
      1,
      1,
      1.232887,
      NULL,
      1,
      0.165249,
      1.920837,
      0,
      0,
      NULL,
      1.954989,
      0.381185,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-11-1977',
      NULL,
      19,
      NULL,
      5,
      NULL,
      1.041767,
      NULL,
      9.973741,
      2.347449,
      NULL,
      0.294512,
      0.186681,
      97.223254,
      0.479512,
      0.225125,
      1,
      1,
      0.036550,
      78,
      NULL,
      92.852920,
      68.065719,
      33,
      89.974007,
      37,
      41.941802,
      56.662828,
      7.284423,
      79,
      44,
      NULL,
      30,
      ' 9- 3-1986',
      13.622426,
      33,
      NULL,
      43.729117,
      20,
      NULL,
      NULL,
      NULL,
      4.434974,
      0,
      ' 2-29-1979',
      5,
      12,
      2,
      8.826537,
      NULL,
      0.471406,
      1,
      NULL,
      NULL,
      72,
      NULL,
      NULL,
      NULL,
      4.799048,
      NULL,
      5,
      NULL,
      0,
      '11-11-1995',
      NULL,
      1,
      3,
      ' 2- 0-2002',
      65,
      3,
      ' 5-28-1974',
      NULL,
      NULL,
      NULL,
      29,
      ' 2-16-1998',
      18.526620,
      ' 0-14-1978',
      2,
      NULL,
      ' 1-16-1985',
      142.969868,
      70.263987,
      ' 7-20-1987',
      0.630433,
      0.294229,
      '10- 4-2000',
      0.590130,
      NULL,
      ' 2-25-1992',
      3,
      2,
      NULL,
      ' 7-28-1990',
      NULL,
      11,
      23.769146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.807456);
commit;
end;
/


