set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9724886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '3',
      '1',
      NULL,
      '3',
      '3',
      '2',
      '4',
      '4',
      '3',
      '2',
      '0',
      '4',
      '3',
      '4',
      NULL,
      NULL,
      '2',
      NULL,
      '3',
      NULL,
      '2',
      '2',
      NULL,
      '1',
      '',
      '2',
      '0',
      '4',
      NULL,
      NULL,
      '',
      NULL,
      '2',
      '1',
      '1',
      '3',
      '2',
      '0',
      '4',
      '2',
      '4',
      '0',
      '1',
      NULL,
      '41430242',
      8.362856,
      65.874349,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      ' 1- 6-1975',
      39,
      23.572091,
      28.993665,
      NULL,
      9.702043,
      5,
      61,
      NULL,
      NULL,
      12,
      44.176098,
      19,
      8.554795,
      17.323646,
      14,
      5,
      4.901542,
      19,
      77.541733,
      14,
      NULL,
      NULL,
      9.936517,
      10,
      1,
      NULL,
      194.692621,
      94,
      95.280913,
      50,
      219,
      ' 3-28-1980',
      NULL,
      38,
      32.968771,
      1.860788,
      9.985946,
      129.817636,
      '10-22-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      4.871111,
      7.276224,
      0,
      7.881874,
      11.522721,
      NULL,
      1.166036,
      1,
      80,
      NULL,
      0,
      108.628229,
      1,
      0.578705,
      27.481009,
      NULL,
      NULL,
      NULL,
      ' 1-13-1978',
      56,
      34,
      49,
      127.656532,
      75.905695,
      95.390994,
      50.269094,
      101,
      NULL,
      7,
      NULL,
      NULL,
      ' 4-14-1978',
      11.346798,
      12.758011,
      7.026730,
      3,
      15,
      91.375088,
      NULL,
      ' 7-19-1981',
      27,
      14,
      '10- 6-1977',
      8.445590,
      7.363627,
      17,
      NULL,
      20.975091,
      7,
      0,
      15,
      NULL,
      88,
      NULL,
      2.197245,
      2,
      26,
      1,
      0.178156,
      NULL,
      1.360075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      1.590743,
      ' 5-23-1997',
      NULL,
      NULL,
      NULL,
      25,
      ' 2-11-1977',
      17.546975,
      ' 9-22-1975',
      1,
      NULL,
      NULL,
      60,
      11,
      ' 2-25-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      ' 6-19-1981',
      2.500542,
      NULL,
      26.360359,
      ' 6-11-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


