set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9702623';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3301',
      '10443302',
      '11421311',
      NULL,
      '14121233',
      '01023321',
      NULL,
      '12032332',
      '34140302',
      '00303130',
      NULL,
      '44040203',
      '20030431',
      '10110400',
      NULL,
      '22220431',
      '14441112',
      '32212332',
      '00303344',
      NULL,
      '33312102',
      '23041221',
      NULL,
      NULL,
      '41320303',
      '11133000',
      NULL,
      '32132032',
      '04222404',
      '34242021',
      '31022221',
      NULL,
      '14133142',
      '00341414',
      '34024214',
      '23044340',
      '44221102',
      NULL,
      '01143231',
      '40012341',
      '13301423',
      NULL,
      '24330202',
      '13211201',
      NULL,
      NULL,
      '12',
      NULL,
      12,
      '0402340',
      NULL,
      0.374126,
      0,
      NULL,
      NULL,
      0.863360,
      ' 7-16-2003',
      NULL,
      9.872772,
      120,
      24,
      NULL,
      35,
      21,
      13,
      15.574561,
      2,
      NULL,
      29.407552,
      NULL,
      0,
      NULL,
      4.694911,
      7.616343,
      10.205015,
      NULL,
      NULL,
      8.715486,
      14,
      19.083310,
      NULL,
      2,
      0,
      50,
      NULL,
      104.054867,
      95.641351,
      44,
      23.185853,
      ' 6- 9-1981',
      50,
      0,
      19.661081,
      41.265858,
      NULL,
      96.334174,
      '11-26-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.270284,
      14.097717,
      8,
      NULL,
      NULL,
      ' 8- 1-2001',
      1,
      1,
      166.984821,
      NULL,
      0,
      165,
      1,
      NULL,
      42.215997,
      NULL,
      NULL,
      NULL,
      ' 9-10-1981',
      106.526412,
      20.674911,
      1.160911,
      NULL,
      76.115939,
      93,
      NULL,
      26,
      5,
      49.261504,
      83.862959,
      NULL,
      ' 7-24-1974',
      1,
      22.918389,
      18.122676,
      77,
      6,
      NULL,
      NULL,
      ' 7- 4-2003',
      26,
      NULL,
      NULL,
      5.471195,
      3,
      1,
      2,
      19,
      0.701377,
      1.547180,
      21.145598,
      0.516227,
      67,
      1.692031,
      3.913835,
      10.579378,
      15.393657,
      6.817669,
      NULL,
      2.793482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      133.647639,
      2,
      ' 8- 1-1990',
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      43.070742,
      NULL,
      11,
      4.909911,
      NULL,
      NULL,
      NULL,
      ' 4-29-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      21,
      ' 0-17-1984',
      65.479412,
      18,
      42,
      ' 8- 3-1991',
      0,
      19,
      ' 3-15-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


