set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1012',
      '13334124',
      '32222023',
      '11312420',
      NULL,
      '00444144',
      '14434400',
      '31411023',
      '23322001',
      '11031214',
      '10110212',
      '32304344',
      '14304332',
      '02004110',
      '30003433',
      NULL,
      '01032324',
      '44132124',
      '41444321',
      '10444113',
      '33133211',
      '33431234',
      NULL,
      '31312410',
      '02202312',
      '32233301',
      '01232224',
      '34041243',
      '22032143',
      '44424114',
      '04043341',
      '02214040',
      NULL,
      NULL,
      '31112201',
      '42020241',
      '13201411',
      NULL,
      '04423203',
      '20310042',
      '00422022',
      NULL,
      '32110031',
      '42132321',
      '11411103',
      '444',
      '03',
      36,
      9,
      NULL,
      3,
      1,
      1,
      NULL,
      '043413',
      1.761209,
      ' 9-19-1985',
      ' 1-27-1995',
      14,
      NULL,
      NULL,
      0.053608,
      8,
      11,
      68.671578,
      13.806516,
      11,
      3.212119,
      23,
      13,
      2.267156,
      11,
      20,
      4,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      7,
      1,
      1.631296,
      5.409669,
      69,
      45,
      5.457549,
      36.751282,
      NULL,
      ' 6- 4-1998',
      12,
      NULL,
      35,
      NULL,
      136,
      107.559220,
      ' 0-23-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      110.560847,
      9.236717,
      NULL,
      4,
      NULL,
      3,
      ' 6-25-1996',
      1.767889,
      NULL,
      174.688972,
      1.142783,
      5,
      106,
      1,
      1.227082,
      55.399494,
      NULL,
      NULL,
      NULL,
      ' 2-17-1975',
      9.904256,
      30.014538,
      12,
      40.412966,
      57,
      NULL,
      39,
      NULL,
      24.323590,
      71,
      26.322710,
      12,
      ' 7- 4-1996',
      14,
      3.435734,
      NULL,
      35,
      37,
      NULL,
      3.473320,
      NULL,
      NULL,
      1,
      ' 2-19-1997',
      NULL,
      3,
      3,
      14.240484,
      11.079488,
      NULL,
      1,
      8,
      0.264728,
      38.164370,
      5.725155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57.929691,
      19,
      '11-20-1980',
      NULL,
      NULL,
      NULL,
      22.146344,
      ' 6-17-1979',
      NULL,
      '11-21-1991',
      11,
      1,
      ' 8-14-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      8,
      ' 8-14-1999',
      29.721784,
      8.536094,
      NULL,
      '10-16-1982',
      1,
      NULL,
      ' 8-17-1987',
      0.706854,
      45,
      15.460172,
      39,
      ' 7- 5-2001',
      49,
      0,
      29.968327,
      '11-29-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


