set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '2',
      NULL,
      '4',
      NULL,
      '1',
      '1',
      NULL,
      '4',
      '0',
      '0',
      '2',
      NULL,
      '0',
      '1',
      '3',
      '0',
      '1',
      NULL,
      '4',
      '2',
      '0',
      '1',
      '',
      '3',
      '',
      '1',
      '4',
      '2',
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      '0',
      '2',
      NULL,
      '1',
      '3',
      '2',
      '3',
      '441',
      NULL,
      22.527081,
      9.896641,
      '3332133',
      1.229772,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 9-18-2002',
      ' 9-15-1977',
      16.583198,
      21.489794,
      13,
      7.546646,
      NULL,
      17,
      9.436766,
      1.633863,
      0.226924,
      12.299359,
      45.085526,
      1,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      7,
      41,
      11.601862,
      29,
      12,
      1.639869,
      48,
      24,
      37,
      34.630622,
      NULL,
      95,
      ' 4-28-1990',
      17.814132,
      26,
      33,
      8.317610,
      24,
      64,
      ' 1-26-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      80,
      17,
      10,
      3.258958,
      8.863095,
      4,
      ' 3-17-1984',
      0.176312,
      1.222472,
      NULL,
      0.106869,
      NULL,
      66.073682,
      NULL,
      0.081645,
      15,
      NULL,
      NULL,
      NULL,
      ' 5-14-1997',
      NULL,
      25,
      94.033427,
      30,
      29.826875,
      70,
      20.431340,
      NULL,
      2,
      31.588747,
      NULL,
      88,
      ' 3-11-1997',
      NULL,
      11,
      NULL,
      29.319974,
      61.178725,
      90.474809,
      6.280736,
      ' 2- 9-1979',
      19,
      23.613314,
      ' 8-20-1988',
      NULL,
      NULL,
      5,
      8,
      7,
      3,
      1.720787,
      NULL,
      1.188407,
      21.992872,
      4.395204,
      NULL,
      14.012896,
      23.325900,
      4.710614,
      3,
      NULL,
      0,
      ' 8- 0-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-11-1991',
      NULL,
      NULL,
      NULL,
      39.485680,
      ' 0- 1-1997',
      25,
      ' 2-14-2001',
      11,
      12.689426,
      ' 5-16-1992',
      66.502190,
      94,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7,
      ' 2- 3-1980',
      50,
      22,
      19,
      ' 9-15-1983',
      1,
      65,
      ' 0- 7-1978',
      5.625153,
      56.392888,
      7,
      2,
      NULL,
      NULL,
      1,
      61.153443,
      ' 5-17-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


