set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '2',
      NULL,
      '4',
      '3',
      '4',
      NULL,
      '4',
      '1',
      '0',
      '4',
      NULL,
      '2',
      '2',
      '0',
      NULL,
      NULL,
      '2',
      NULL,
      '3',
      NULL,
      '3',
      '0',
      NULL,
      '4',
      '',
      '3',
      NULL,
      NULL,
      '1',
      '3',
      '',
      '',
      '1',
      '0',
      '4',
      NULL,
      '4',
      '3',
      NULL,
      '4',
      '0',
      NULL,
      '3',
      '103',
      '12234002',
      40,
      NULL,
      '1111440',
      2.064900,
      NULL,
      3,
      1,
      '032103',
      1.038696,
      ' 1- 7-1998',
      ' 8-17-1987',
      NULL,
      19.300683,
      27.179554,
      NULL,
      31.842686,
      14,
      70.171312,
      11,
      17.113612,
      3.314471,
      NULL,
      9,
      14.709181,
      21.372684,
      4.502302,
      21.659358,
      12,
      NULL,
      NULL,
      5,
      19.112615,
      9.926485,
      109.948832,
      16,
      NULL,
      77.862272,
      119,
      24,
      33.192833,
      89.318065,
      104.050604,
      ' 8-14-1989',
      0,
      45.067440,
      NULL,
      7.013968,
      144.850521,
      41,
      ' 7- 3-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78,
      7,
      NULL,
      8,
      0,
      10.246748,
      ' 8-13-1991',
      0.145626,
      1.406819,
      222,
      0,
      0,
      128,
      0.166038,
      NULL,
      104,
      NULL,
      NULL,
      NULL,
      ' 6-29-1997',
      95,
      59.533847,
      119.697314,
      51.752419,
      43.654917,
      43,
      79.531477,
      106,
      103.433243,
      4,
      NULL,
      87.364332,
      '11-21-1987',
      18.353852,
      NULL,
      19,
      7.787987,
      27,
      40.993697,
      NULL,
      ' 1-14-1974',
      25.840449,
      11.916941,
      NULL,
      NULL,
      2.676872,
      NULL,
      0.245665,
      5,
      NULL,
      1,
      15,
      0.614822,
      30.189226,
      NULL,
      1,
      5.590759,
      16.817381,
      3,
      NULL,
      2,
      1.938956,
      ' 1- 6-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      70.272444,
      10,
      ' 4-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-12-1998',
      NULL,
      ' 0-20-1998',
      NULL,
      14.873405,
      ' 4-26-1976',
      6.134752,
      117.384929,
      ' 1-26-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.451757,
      '10-28-1984',
      7,
      6.618625,
      34.551776,
      ' 5-23-1982',
      1,
      78,
      ' 6-23-1979',
      1,
      7.782700,
      NULL,
      0,
      NULL,
      6.320312,
      0.470987,
      136.044416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


