set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9335475';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2441',
      '31010024',
      '32000113',
      '40232023',
      '40410413',
      NULL,
      '00014431',
      '33143012',
      '20301032',
      NULL,
      '32332003',
      '22433331',
      NULL,
      '43244042',
      '43214001',
      '01231430',
      NULL,
      '33023040',
      NULL,
      '13012121',
      '31243034',
      '40134333',
      NULL,
      '42434114',
      '04211403',
      NULL,
      '04140134',
      '10412043',
      '21014011',
      NULL,
      '12240224',
      '23423013',
      NULL,
      '13412202',
      NULL,
      '13001000',
      '43301401',
      '00044232',
      '21022014',
      '24203314',
      '31122144',
      '33422203',
      NULL,
      '10100122',
      '44210211',
      '412',
      '22',
      NULL,
      NULL,
      '0420422',
      2.666407,
      0,
      2,
      NULL,
      '444242',
      0.668102,
      ' 8-24-1982',
      ' 6-26-1990',
      28.286973,
      NULL,
      51.488752,
      17,
      NULL,
      0,
      95,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      5.209481,
      17.069667,
      20,
      16.329796,
      15.082545,
      12,
      11,
      13.373171,
      6,
      10.466099,
      55,
      20.291382,
      1.115656,
      67.178161,
      128.921999,
      NULL,
      228.780726,
      21,
      182.354057,
      '11- 9-2000',
      38.956250,
      19.573720,
      18,
      10,
      26.455798,
      79,
      ' 1-21-1974',
      1,
      3.301018,
      1,
      NULL,
      3.968386,
      1.903143,
      1,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      0,
      1.949133,
      0.706233,
      0,
      NULL,
      0,
      0.415039,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 4-1994',
      50,
      14,
      NULL,
      6.390148,
      6.108157,
      NULL,
      ' 0-17-1993',
      0,
      1,
      NULL,
      1,
      0,
      167.815790,
      NULL,
      0,
      75,
      NULL,
      NULL,
      NULL,
      ' 6-26-1994',
      2,
      30,
      85.190090,
      7.715022,
      NULL,
      29,
      86,
      48.819850,
      56.901952,
      64.064782,
      90,
      94.009650,
      ' 1-19-1980',
      14,
      7,
      NULL,
      NULL,
      38.533301,
      2.049955,
      7,
      ' 2-11-1990',
      23,
      NULL,
      '11-10-1978',
      8,
      7.762951,
      15,
      6,
      17,
      1.727078,
      1.246812,
      NULL,
      0.692294,
      29.974101,
      0.077241,
      2,
      NULL,
      12.276377,
      1.100499,
      1.599232,
      1,
      0,
      '11-25-1998',
      0,
      NULL,
      1,
      ' 6-28-1993',
      206,
      2.822221,
      NULL,
      32,
      3.120752,
      '11-22-1978',
      20.315777,
      NULL,
      14,
      ' 1-28-1996',
      6,
      2.172117,
      ' 1- 2-1987',
      NULL,
      91.184350,
      NULL,
      NULL,
      4.436373,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      11.266029,
      '10- 2-1994',
      67.918827,
      NULL,
      5.404513,
      NULL,
      1.181703,
      59.158920,
      ' 5-11-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


