set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4614147';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31422010',
      '01221234',
      '10313320',
      '10442132',
      '02304241',
      '20203212',
      '24244042',
      '31034122',
      '14314132',
      '03321330',
      '00221041',
      NULL,
      '22140440',
      '31322303',
      '12141102',
      '22012044',
      '30331423',
      '24113231',
      NULL,
      '41231431',
      NULL,
      '33212423',
      '21010030',
      NULL,
      '22410141',
      '41011122',
      '21001311',
      '33434033',
      '40014031',
      '43410030',
      '23412430',
      NULL,
      '21324022',
      '24101322',
      NULL,
      '23110020',
      '33443101',
      '23220303',
      NULL,
      '24423031',
      '',
      '',
      NULL,
      NULL,
      '3412440',
      1,
      1.473922,
      NULL,
      NULL,
      '403432',
      3,
      ' 5-25-1982',
      ' 5- 3-1991',
      NULL,
      NULL,
      8.823339,
      2,
      3.417839,
      3,
      64,
      17,
      NULL,
      24,
      24.916155,
      13.698605,
      20.492298,
      9.831540,
      36.555496,
      17,
      NULL,
      12.747457,
      13,
      11.244161,
      NULL,
      1,
      86,
      0.479839,
      NULL,
      NULL,
      210.223158,
      43.985201,
      154.966540,
      37,
      124,
      NULL,
      37,
      1.723020,
      28,
      13.793743,
      91,
      131.933365,
      ' 0- 2-1986',
      1.141943,
      0.936249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914906,
      1,
      9.822749,
      1,
      0.530097,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-17-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 3-1993',
      93.732649,
      143.984510,
      43.689245,
      19.156821,
      63.288357,
      85.642731,
      41,
      20.588692,
      1.902178,
      40.676947,
      60,
      22,
      NULL,
      12,
      16.583114,
      NULL,
      NULL,
      35,
      89.275977,
      5.040598,
      ' 5- 0-1983',
      8.569177,
      7.957135,
      ' 5- 6-1985',
      4.323013,
      10.293317,
      3.708631,
      9,
      NULL,
      10,
      NULL,
      14,
      NULL,
      4.721925,
      10.351617,
      NULL,
      2.378603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.912697,
      5.378184,
      3,
      ' 3-25-1991',
      NULL,
      NULL,
      ' 1-21-2002',
      13,
      NULL,
      NULL,
      6,
      NULL,
      37,
      NULL,
      217.127123,
      ' 0-17-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827906,
      1,
      66,
      NULL,
      1,
      4,
      1,
      0.601523,
      99.688513,
      1.694843,
      0.038946,
      NULL,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      4.730201,
      0,
      1,
      29.797350,
      0.686626,
      0.251151,
      NULL,
      NULL,
      NULL,
      12.578643,
      NULL,
      NULL,
      24,
      1,
      3.458579,
      NULL,
      NULL,
      0.596378,
      NULL,
      0.970035,
      NULL,
      0.274720,
      NULL,
      1,
      0,
      NULL,
      15,
      NULL,
      35.800854,
      NULL,
      NULL,
      15.714136,
      NULL,
      1,
      3.504015,
      0,
      11.944577,
      1.087574,
      NULL,
      0,
      1,
      NULL,
      NULL,
      ' 4-14-1985',
      ' 6-22-1990',
      NULL,
      ' 7-27-1983',
      ' 9-24-1999',
      NULL,
      NULL);
commit;
end;
/


