set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8433669';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30201021',
      '31013032',
      '42124143',
      '44411422',
      NULL,
      '12220042',
      NULL,
      '34332110',
      '43213022',
      '01240134',
      '20241400',
      NULL,
      '32001002',
      '42201424',
      NULL,
      NULL,
      '20122211',
      '32334222',
      '01001414',
      '13413224',
      '14220201',
      '01313234',
      NULL,
      '10042043',
      '02333302',
      '11111040',
      '32433031',
      '42122043',
      '14133123',
      '43104004',
      '10412022',
      '10221010',
      '01111412',
      '04010211',
      NULL,
      '30240322',
      '11342324',
      NULL,
      '13132134',
      NULL,
      NULL,
      NULL,
      '03101031',
      '13004203',
      '440',
      '23',
      NULL,
      NULL,
      '3310404',
      0,
      1,
      2,
      NULL,
      '131030',
      0.341082,
      ' 7- 9-1988',
      ' 4- 1-1992',
      28.521285,
      NULL,
      15,
      NULL,
      8,
      22.905148,
      80,
      11.874054,
      NULL,
      16,
      36.914385,
      4,
      13.191555,
      15,
      23.119644,
      20,
      16,
      19.123296,
      83,
      16,
      16,
      2.343731,
      36,
      1.924334,
      NULL,
      147.988628,
      87,
      58.651639,
      NULL,
      28.451416,
      203.721982,
      ' 4-15-1974',
      49.131993,
      15.688363,
      8,
      37,
      NULL,
      20,
      ' 0-13-1996',
      NULL,
      0.832232,
      0,
      2,
      NULL,
      4.179814,
      0.063514,
      NULL,
      NULL,
      0,
      3.348604,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1.738587,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-12-1989',
      60.353044,
      NULL,
      NULL,
      13.614503,
      5,
      NULL,
      ' 3-14-2003',
      1.908990,
      0,
      NULL,
      NULL,
      1,
      98,
      0,
      1.816555,
      NULL,
      1,
      1,
      124,
      ' 2-20-1989',
      18,
      NULL,
      30.722308,
      NULL,
      NULL,
      1.608257,
      40,
      4.632135,
      11,
      NULL,
      75,
      73,
      NULL,
      22,
      42.228797,
      1.497247,
      NULL,
      121,
      1.717878,
      NULL,
      ' 7-26-1990',
      NULL,
      4.076012,
      NULL,
      9,
      10,
      10,
      3,
      8.582648,
      16,
      1.790972,
      21,
      1.088971,
      NULL,
      0,
      0,
      12,
      20.060116,
      0,
      1.345184,
      NULL,
      0.489260,
      '11-12-1991',
      3.567250,
      8,
      NULL,
      ' 2-17-1989',
      7,
      0,
      ' 5-14-1993',
      73.641083,
      4.661404,
      ' 0-21-1974',
      35,
      ' 6-12-1993',
      21.012130,
      ' 2- 5-1983',
      15,
      12.845299,
      ' 1-17-1987',
      NULL,
      NULL,
      NULL,
      8.455767,
      21,
      ' 0-10-1986',
      10,
      14.075437,
      '11-23-1980',
      0,
      3,
      NULL,
      NULL,
      2.307697,
      8.131363,
      16.715691,
      ' 3- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


