set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228957';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0300',
      '42200414',
      '33110101',
      '23113300',
      '14034011',
      '03140024',
      NULL,
      '30323114',
      '22003012',
      '01321003',
      '24012221',
      NULL,
      NULL,
      '14403034',
      '21213413',
      '01340210',
      '12311022',
      '01130142',
      NULL,
      '12441431',
      '12001103',
      '33023023',
      '14330221',
      '02341441',
      NULL,
      NULL,
      '10111421',
      '32011120',
      '11222223',
      '20112333',
      '11134000',
      '10322000',
      '40231414',
      '24430431',
      '23414211',
      '11301213',
      '23120310',
      NULL,
      '02444104',
      '42423124',
      '14333431',
      '22314024',
      '34221230',
      '21241133',
      '32141103',
      NULL,
      '40',
      NULL,
      NULL,
      '1102021',
      NULL,
      NULL,
      2,
      NULL,
      '222212',
      5.781544,
      ' 4-23-1987',
      '10- 5-1983',
      14,
      NULL,
      35,
      NULL,
      34,
      NULL,
      NULL,
      0.084980,
      23,
      23,
      3,
      2.615462,
      8.464685,
      NULL,
      NULL,
      12,
      22.946366,
      9.256804,
      53,
      3.509191,
      28,
      NULL,
      NULL,
      NULL,
      0.504079,
      47,
      181.123601,
      NULL,
      129,
      55.877784,
      173.040568,
      ' 3- 6-1976',
      32.316985,
      NULL,
      NULL,
      24.532390,
      NULL,
      NULL,
      ' 7-21-1982',
      1.598504,
      NULL,
      1.185354,
      0.525608,
      NULL,
      1,
      1.603410,
      1,
      1,
      1.141589,
      3.231197,
      1.993844,
      NULL,
      1,
      1.817886,
      1.518173,
      0.843338,
      NULL,
      0.320288,
      1.355183,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-18-1983',
      66,
      2.967478,
      36.570485,
      5.720482,
      32.927975,
      NULL,
      ' 0- 8-2000',
      2,
      NULL,
      4.322820,
      1.615810,
      5.159720,
      14.881777,
      1.730525,
      0.969264,
      36,
      0.075940,
      2.832103,
      23.852704,
      ' 4-29-1999',
      56,
      26.014107,
      53,
      44.547474,
      2.867614,
      60,
      7,
      39.602894,
      21,
      80,
      24,
      37.805040,
      ' 7-10-1977',
      20,
      13,
      1.340615,
      49,
      11,
      95,
      11.920333,
      NULL,
      0,
      0.405051,
      '10-28-1999',
      18.694736,
      19,
      17.523946,
      NULL,
      12.924441,
      2.304784,
      0.996185,
      10,
      1.656062,
      63,
      1.797974,
      11,
      2.947160,
      NULL,
      2.992302,
      NULL,
      1,
      0.625807,
      ' 6- 8-1988',
      2,
      1.726035,
      3.804760,
      ' 6- 6-1984',
      28,
      6.572135,
      ' 2-19-1975',
      NULL,
      NULL,
      NULL,
      31.933319,
      ' 9-24-1980',
      25.296473,
      ' 6-18-1975',
      15,
      14,
      ' 1-26-1979',
      NULL,
      26.611011,
      NULL,
      NULL,
      8.650181,
      ' 4-18-1986',
      NULL,
      NULL,
      NULL,
      2,
      2,
      20,
      NULL,
      29,
      23,
      17.179392,
      ' 6-19-1979',
      NULL,
      106.817964,
      NULL,
      17,
      NULL,
      0,
      8,
      ' 9- 7-2002',
      52.012430,
      1,
      5.025676,
      '11- 1-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


