set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9529157';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4010',
      '11424342',
      '13202232',
      '31444242',
      '03121220',
      '34213422',
      '34341240',
      '04433133',
      '31013433',
      '21304014',
      NULL,
      '04021322',
      '44230313',
      '21110240',
      '13022424',
      NULL,
      '44342040',
      NULL,
      '13032022',
      '41140031',
      '41122130',
      '42132320',
      '14010441',
      NULL,
      '44223024',
      '24043031',
      NULL,
      NULL,
      NULL,
      '34012030',
      '43200103',
      '03111110',
      '13240032',
      '14441202',
      NULL,
      NULL,
      '23222310',
      NULL,
      '34412043',
      '10000212',
      '13241132',
      '41243133',
      '03211310',
      '33030320',
      '10434323',
      '444',
      '02',
      NULL,
      NULL,
      '1024022',
      0,
      0.269822,
      1,
      NULL,
      '344100',
      5,
      NULL,
      ' 2- 9-1977',
      NULL,
      NULL,
      NULL,
      13.662987,
      12,
      15.731876,
      60.842706,
      15.909675,
      20.472049,
      4,
      14,
      11,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      11.275439,
      0.420497,
      40,
      NULL,
      0.067991,
      65.321097,
      NULL,
      29.414241,
      157,
      31,
      2.797236,
      NULL,
      29,
      19,
      NULL,
      16.343933,
      67.431373,
      107.919631,
      ' 8-18-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      140,
      5,
      2.142997,
      124.051043,
      0.081344,
      1.061337,
      25.499619,
      NULL,
      NULL,
      NULL,
      ' 2- 1-1983',
      32,
      35,
      13,
      65,
      21.596060,
      NULL,
      0.575614,
      73,
      49,
      39.147250,
      39.847929,
      NULL,
      ' 4-10-2002',
      4,
      5,
      14,
      35.313143,
      25,
      102,
      7.255215,
      ' 5-11-1984',
      14,
      11,
      '10-12-1991',
      NULL,
      14,
      NULL,
      3,
      1,
      7.629699,
      1,
      4.800797,
      NULL,
      80.728753,
      2,
      9.472738,
      4.875038,
      NULL,
      NULL,
      0,
      NULL,
      0,
      ' 1-10-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      101,
      NULL,
      '11-28-1981',
      NULL,
      NULL,
      NULL,
      0,
      ' 3- 2-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 4-1987',
      NULL,
      NULL,
      NULL,
      4,
      8.776583,
      ' 1-10-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 1-17-2000',
      10.536304,
      NULL,
      3.631968,
      ' 7-27-1985',
      3,
      25.494363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


