set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9529157';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4222',
      '44002304',
      '41244043',
      '30243404',
      NULL,
      '34324203',
      '34414414',
      NULL,
      '21004112',
      NULL,
      '44412424',
      '24342234',
      '10343101',
      '44420032',
      '14103303',
      '22032322',
      '22114014',
      '24303010',
      NULL,
      '31141402',
      '34302120',
      NULL,
      NULL,
      NULL,
      '01230123',
      '42411402',
      '04030133',
      '00141014',
      '23122234',
      '30320414',
      '23313020',
      '34340411',
      NULL,
      '30334031',
      '01032401',
      '44123400',
      '43332312',
      NULL,
      '22240333',
      '12011003',
      '22034304',
      '33010224',
      '01303033',
      NULL,
      '11102241',
      '122',
      '10',
      11.688313,
      10,
      NULL,
      5.209609,
      0,
      1,
      NULL,
      NULL,
      5,
      ' 1- 8-1995',
      ' 8-27-2001',
      NULL,
      58,
      10.760985,
      16,
      20.342456,
      12,
      NULL,
      8,
      12.969577,
      0.183904,
      5.369319,
      11,
      NULL,
      4,
      3,
      19,
      12.042500,
      NULL,
      NULL,
      NULL,
      3.409270,
      16,
      11.611374,
      0,
      NULL,
      19,
      NULL,
      51.468013,
      30.422712,
      112,
      37,
      '10- 2-1995',
      53,
      16,
      NULL,
      6,
      90.500650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11,
      30,
      7.771366,
      0.310904,
      ' 8- 9-1993',
      1,
      1,
      120,
      4.723235,
      NULL,
      22,
      NULL,
      0.031403,
      48,
      NULL,
      NULL,
      NULL,
      ' 9-27-2002',
      8,
      58,
      52,
      25.762382,
      42,
      58,
      1,
      5,
      52,
      NULL,
      7.002570,
      9,
      NULL,
      9,
      NULL,
      7.782798,
      NULL,
      NULL,
      60.769115,
      3,
      NULL,
      6.969939,
      8.622574,
      ' 9-12-1975',
      8,
      3.468736,
      3,
      4,
      NULL,
      9,
      NULL,
      6.377527,
      1.830780,
      43.942837,
      7.207814,
      0.562346,
      4.787916,
      3,
      4,
      10.001072,
      NULL,
      2,
      ' 5-22-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      96.743387,
      3.353360,
      ' 3- 5-1988',
      NULL,
      NULL,
      NULL,
      36,
      ' 8- 6-1981',
      NULL,
      NULL,
      12.107981,
      0.684521,
      '10-10-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      12.976440,
      ' 3-16-1976',
      8.512986,
      3.742694,
      17,
      '10-12-1994',
      1,
      140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      111,
      ' 2-25-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


