set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9014854';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0432',
      '01344021',
      '31411243',
      '10322401',
      '02424414',
      '34331332',
      '03020201',
      '23424410',
      '21432411',
      '31032223',
      '21341324',
      '33112433',
      '42031332',
      NULL,
      '02214323',
      '12211240',
      '13111042',
      NULL,
      '22320240',
      '21010314',
      '12132214',
      NULL,
      '32004221',
      '30324040',
      '00421304',
      '13234100',
      '20442134',
      '31444312',
      '21332242',
      NULL,
      '02440141',
      '02341012',
      '21042144',
      '32201100',
      '01214402',
      NULL,
      '04004130',
      '32032113',
      '13422244',
      '41142324',
      '24121443',
      '32433340',
      '14330412',
      '23301104',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '0313000',
      2.646033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 9-1983',
      ' 5- 6-1986',
      106,
      NULL,
      6.761742,
      14,
      4,
      4.099799,
      36,
      4,
      NULL,
      0,
      NULL,
      12,
      5,
      6,
      NULL,
      0.542424,
      2.346578,
      4.746176,
      4,
      8.273040,
      0,
      6,
      12,
      1.174521,
      NULL,
      2.883846,
      NULL,
      NULL,
      NULL,
      86,
      32,
      ' 5-20-1979',
      NULL,
      6,
      10.493259,
      NULL,
      102,
      130.190602,
      ' 7-20-1994',
      6.536627,
      30.648978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      11.595221,
      0.603676,
      NULL,
      7.474878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-22-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-28-1985',
      NULL,
      54,
      NULL,
      29,
      44.037516,
      63,
      24.530730,
      66.005916,
      NULL,
      52.837875,
      56.371485,
      24.665749,
      ' 5-28-1999',
      3,
      7.953780,
      4.413451,
      13,
      3.221930,
      NULL,
      1.461933,
      '10-23-1984',
      5.005806,
      NULL,
      ' 2-18-1979',
      6.405685,
      5.908908,
      8,
      6.594471,
      17,
      3.195640,
      NULL,
      NULL,
      NULL,
      66,
      12.798348,
      5.647003,
      7.216584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-14-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.346585,
      2.254375,
      ' 4- 3-1976',
      3,
      183,
      ' 6- 8-1987',
      4.751553,
      15,
      5.533700,
      70,
      ' 8-21-2003',
      NULL,
      1,
      19,
      ' 5- 2-1995',
      NULL,
      NULL,
      NULL,
      23.448684,
      62.881741,
      160,
      2,
      NULL,
      22,
      NULL,
      82,
      7.084024,
      58.260024,
      1,
      24,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441111,
      2,
      5,
      1.267180,
      10.993524,
      573,
      23,
      4.792452,
      21,
      0.435949,
      14.987919,
      5.199210,
      0,
      NULL,
      3.390703,
      1,
      1,
      NULL,
      25.983550,
      9,
      11,
      17,
      20,
      1.528544,
      0.371864,
      NULL,
      0,
      0,
      0.480266,
      4,
      NULL,
      23.894831,
      3.452886,
      4.487306,
      0,
      0,
      NULL,
      15,
      0,
      0.444979,
      28,
      29.166697,
      0.175969,
      33.273904,
      NULL,
      34,
      5.523530,
      18,
      0,
      NULL,
      1,
      NULL,
      31.466853,
      NULL,
      ' 2-27-1998',
      ' 5-11-2000',
      ' 7-14-1990',
      '10-20-1990',
      '11-27-1991',
      '10-10-1986',
      NULL);
commit;
end;
/


