set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6012210';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3143',
      '30002220',
      '00201242',
      '23421401',
      '13420403',
      '40323031',
      '13232112',
      '21340333',
      '10143330',
      '20342111',
      '12134123',
      '20010430',
      '34334021',
      '03041122',
      '41030422',
      '33411204',
      '42300003',
      '44041201',
      '32231441',
      '31133314',
      '32241011',
      '20324332',
      '31240442',
      '33304300',
      '22434004',
      '34022003',
      '33214133',
      NULL,
      '04030443',
      NULL,
      '24320321',
      '31333043',
      '30034201',
      '43443241',
      '21241340',
      '03431012',
      '11244041',
      '21433111',
      '03213014',
      '43300411',
      '22204420',
      '20223434',
      '10321243',
      '23141033',
      '22143122',
      '',
      '',
      NULL,
      NULL,
      '2310333',
      NULL,
      0,
      0,
      NULL,
      '341344',
      1.526226,
      '11-19-2002',
      ' 8- 6-1975',
      1.378681,
      NULL,
      30.403382,
      1.023533,
      9.262816,
      NULL,
      NULL,
      2,
      30,
      11,
      38.118344,
      NULL,
      18,
      4.703050,
      10.831222,
      22,
      5.865104,
      23,
      18.548423,
      10.833267,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      31.556641,
      114.456083,
      NULL,
      226,
      220.596929,
      133,
      NULL,
      15.059174,
      6.872751,
      NULL,
      5.221476,
      185,
      NULL,
      ' 3-14-1996',
      5.489290,
      9.779164,
      NULL,
      0.799857,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510406,
      2,
      7,
      NULL,
      0.219513,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 6-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-27-1989',
      46,
      41,
      76,
      58.675852,
      NULL,
      69,
      NULL,
      NULL,
      101,
      29.645967,
      85,
      93,
      ' 6- 4-1998',
      10.975540,
      NULL,
      16,
      32,
      52,
      7.280588,
      NULL,
      NULL,
      22,
      9,
      ' 1-22-1975',
      NULL,
      13.998250,
      9,
      4,
      2.301380,
      1.821185,
      NULL,
      NULL,
      NULL,
      55,
      2.147134,
      1.652774,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-14-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.758534,
      4.397798,
      NULL,
      NULL,
      23,
      ' 2- 5-1986',
      NULL,
      14.676046,
      22.040771,
      20,
      NULL,
      42.400667,
      0.220752,
      153,
      ' 2- 5-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      85,
      20.765423,
      NULL,
      NULL,
      75.692450,
      4,
      1,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1.369148,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      118.040749,
      0,
      2.668441,
      1.866749,
      NULL,
      32,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      1.226806,
      NULL,
      2,
      12.173289,
      0.194143,
      NULL,
      1.908967,
      NULL,
      1,
      NULL,
      NULL,
      36.890881,
      NULL,
      26,
      NULL,
      NULL,
      21,
      NULL,
      5,
      7.143807,
      1.950962,
      1,
      NULL,
      1.812016,
      0,
      0,
      NULL,
      NULL,
      ' 9- 5-1993',
      NULL,
      ' 1-28-2000',
      ' 2- 1-1982',
      ' 5- 2-1996',
      '11- 1-1998',
      NULL);
commit;
end;
/


