set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7126107';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3312',
      NULL,
      '43301213',
      '12443132',
      '22400211',
      '43321102',
      '44224424',
      '04010411',
      NULL,
      '32314024',
      '00333123',
      NULL,
      '42440014',
      '24423001',
      '04422414',
      '04024344',
      '14120240',
      '40042011',
      '00003143',
      '42411304',
      '00102023',
      '13411134',
      NULL,
      '30412031',
      '22230443',
      '22114212',
      '12141242',
      '21144041',
      '14322401',
      '13444333',
      '11031243',
      '13401441',
      NULL,
      NULL,
      '24243002',
      '31422012',
      '13111232',
      '04313004',
      '23243222',
      '33320102',
      '33010243',
      '24022040',
      '43441324',
      '34321002',
      '11033002',
      '',
      '',
      NULL,
      NULL,
      '1320113',
      1,
      NULL,
      1,
      NULL,
      '002340',
      0.758755,
      '10-21-1983',
      ' 4- 0-2003',
      NULL,
      NULL,
      13.630909,
      NULL,
      30,
      10.661349,
      49.758411,
      22,
      27.258296,
      19,
      12.617134,
      5,
      NULL,
      17.581547,
      NULL,
      6.600737,
      2,
      27,
      81.498508,
      NULL,
      31,
      NULL,
      14.331530,
      6.433873,
      NULL,
      81.806893,
      69,
      21,
      139,
      143.457179,
      32,
      ' 6-11-2002',
      61.027641,
      5.289088,
      18,
      33,
      173,
      145.398882,
      ' 6-20-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-21-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.709007,
      13.122855,
      NULL,
      1,
      NULL,
      95,
      11,
      ' 0- 6-1975',
      8,
      13.781880,
      ' 6-17-1977',
      6,
      12,
      0,
      3.233872,
      10.992280,
      2,
      NULL,
      NULL,
      NULL,
      5,
      1.210701,
      0,
      5.671888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 6-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.542033,
      42,
      NULL,
      NULL,
      NULL,
      36.694723,
      ' 8- 9-1986',
      13.809210,
      16,
      15,
      27.564346,
      NULL,
      NULL,
      0,
      44,
      '10-19-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.991400,
      4,
      3,
      0.246792,
      6,
      NULL,
      0.300027,
      1.675477,
      51,
      NULL,
      NULL,
      62,
      1,
      1.875799,
      45.320595,
      2,
      4.018812,
      10,
      NULL,
      24.025766,
      NULL,
      1.426252,
      NULL,
      NULL,
      1,
      0,
      1.303328,
      1.083565,
      0.595291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.603313,
      0.082338,
      NULL,
      1.898651,
      0.734747,
      1.738708,
      29,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.810571,
      NULL,
      1.507349,
      0.095268,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      2,
      1,
      1.908383,
      1,
      0,
      1.420455,
      NULL,
      NULL,
      ' 5-13-2001',
      '10-24-2001',
      '11-19-1979',
      ' 2- 8-2001',
      ' 5-19-1981',
      '10-16-1996',
      ' 2-24-1995',
      NULL);
commit;
end;
/


